/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.net.URI;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.cluster.AbstractModeSwitcher;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.transaction.MasterTxIdGenerator;
import org.neo4j.kernel.ha.transaction.SlaveTxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;

public class TxIdGeneratorModeSwitcher
extends AbstractModeSwitcher<TxIdGenerator> {
    private final HaXaDataSourceManager xaDsm;
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactory requestContextFactory;
    private StringLogger msgLog;
    private Config config;
    private Slaves slaves;

    public TxIdGeneratorModeSwitcher(HighAvailabilityMemberStateMachine stateMachine, DelegateInvocationHandler<TxIdGenerator> delegate, HaXaDataSourceManager xaDsm, DelegateInvocationHandler<Master> master, RequestContextFactory requestContextFactory, StringLogger msgLog, Config config, Slaves slaves) {
        super(stateMachine, delegate);
        this.xaDsm = xaDsm;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.msgLog = msgLog;
        this.config = config;
        this.slaves = slaves;
    }

    @Override
    protected TxIdGenerator getMasterImpl() {
        return new MasterTxIdGenerator(MasterTxIdGenerator.from(this.config), this.msgLog, this.slaves);
    }

    @Override
    protected TxIdGenerator getSlaveImpl(URI serverHaUri) {
        return new SlaveTxIdGenerator((Integer)this.config.get(ClusterSettings.server_id), this.master.cement(), HighAvailabilityModeSwitcher.getServerId(serverHaUri), this.requestContextFactory, this.xaDsm);
    }
}

