/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.backup.BackupEmbeddedIT;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.ha.ClusterManager;

@Ignore(value="Breaks occasionally, needs investigation")
public class BackupHaIT {
    private DbRepresentation representation;
    private ClusterManager clusterManager;
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void startCluster() throws Throwable {
        FileUtils.deleteDirectory((File)BackupEmbeddedIT.PATH);
        FileUtils.deleteDirectory((File)BackupEmbeddedIT.BACKUP_PATH);
        this.clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), BackupEmbeddedIT.PATH, MapUtil.stringMap((String[])new String[]{OnlineBackupSettings.online_backup_enabled.name(), "true"})){

            @Override
            protected void config(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
                builder.setConfig(OnlineBackupSettings.online_backup_server, ":" + (4444 + serverId.toIntegerIndex()));
            }
        };
        this.clusterManager.start();
        this.cluster = this.clusterManager.getDefaultCluster();
        this.representation = BackupEmbeddedIT.createSomeData((GraphDatabaseService)this.cluster.getMaster());
    }

    @After
    public void stopCluster() throws Throwable {
        this.clusterManager.stop();
        this.clusterManager.shutdown();
    }

    @Test
    public void makeSureBackupCanBePerformedFromClusterWithDefaultName() throws Throwable {
        this.testBackupFromCluster(null);
    }

    @Test
    public void makeSureBackupCanBePerformedFromWronglyNamedCluster() throws Throwable {
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:5001", BackupEmbeddedIT.BACKUP_PATH.getPath(), "non.existent")));
    }

    private void testBackupFromCluster(String askForCluster) throws Throwable {
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:5001", BackupEmbeddedIT.BACKUP_PATH.getPath(), askForCluster)));
        Assert.assertEquals((Object)this.representation, (Object)DbRepresentation.of((File)BackupEmbeddedIT.BACKUP_PATH));
        ClusterManager.ManagedCluster cluster = this.clusterManager.getCluster(askForCluster == null ? "neo4j.ha" : askForCluster);
        DbRepresentation newRepresentation = BackupEmbeddedIT.createSomeData((GraphDatabaseService)cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])this.backupArguments("localhost:5001", BackupEmbeddedIT.BACKUP_PATH.getPath(), askForCluster)));
        Assert.assertEquals((Object)newRepresentation, (Object)DbRepresentation.of((File)BackupEmbeddedIT.BACKUP_PATH));
    }

    private String[] backupArguments(String from, String to, String clusterName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-from");
        args.add(from);
        args.add("-to");
        args.add(to);
        if (clusterName != null) {
            args.add("-cluster");
            args.add(clusterName);
        }
        return args.toArray(new String[args.size()]);
    }
}

