/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.Arrays;
import java.util.Map;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;

public class HighlyAvailableGraphDatabaseFactory
extends GraphDatabaseFactory {
    public HighlyAvailableGraphDatabaseFactory() {
        this.settingsClasses = Arrays.asList(GraphDatabaseSettings.class, ClusterSettings.class, HaSettings.class);
    }

    public GraphDatabaseService newHighlyAvailableDatabase(String path) {
        return this.newEmbeddedDatabaseBuilder(path).newGraphDatabase();
    }

    public GraphDatabaseBuilder newHighlyAvailableDatabaseBuilder(final String path) {
        return new GraphDatabaseBuilder(new GraphDatabaseBuilder.DatabaseCreator(){

            public GraphDatabaseService newDatabase(Map<String, String> config) {
                config.put("ephemeral", "false");
                return new HighlyAvailableGraphDatabase(path, config, (InternalAbstractGraphDatabase.Dependencies)HighlyAvailableGraphDatabaseFactory.this.databaseDependencies());
            }
        });
    }
}

