/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.zoo;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.Pair;

public class Machine {
    private final InstanceId machineId;
    private final int sequenceId;
    private final long lastCommittedTxId;
    private final Pair<String, Integer> server;
    private final int backupPort;
    private final int masterForCommittedTxId;

    public Machine(InstanceId machineId, int sequenceId, long lastCommittedTxId, int masterForCommittedTxId, String server, int backupPort) {
        this.machineId = machineId;
        this.sequenceId = sequenceId;
        this.lastCommittedTxId = lastCommittedTxId;
        this.masterForCommittedTxId = masterForCommittedTxId;
        this.server = server != null ? Machine.splitIpAndPort(server) : null;
        this.backupPort = backupPort;
    }

    public InstanceId getMachineId() {
        return this.machineId;
    }

    public long getLastCommittedTxId() {
        return this.lastCommittedTxId;
    }

    public boolean wasCommittingMaster() {
        return this.masterForCommittedTxId == this.machineId.toIntegerIndex();
    }

    public int getMasterForCommittedTxId() {
        return this.masterForCommittedTxId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public Pair<String, Integer> getServer() {
        return this.server;
    }

    public String getServerAsString() {
        return this.server == null ? null : (String)this.server.first() + ":" + this.server.other() + "?serverId=" + this.machineId;
    }

    public int getBackupPort() {
        return this.backupPort;
    }

    public String toString() {
        return "MachineInfo[ID:" + this.machineId + ", sequence:" + this.sequenceId + ", last tx:" + this.lastCommittedTxId + ", server:" + this.server + ", master for last tx:" + this.masterForCommittedTxId + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Machine && ((Machine)obj).machineId == this.machineId;
    }

    public int hashCode() {
        return this.machineId.hashCode() * 19;
    }

    public static Pair<String, Integer> splitIpAndPort(String server) {
        String[] pos = server.split(":");
        if (pos.length == 3) {
            URI serverURI = URI.create(server);
            return Pair.of((Object)serverURI.getHost(), (Object)serverURI.getPort());
        }
        return Pair.of((Object)pos[0], (Object)Integer.parseInt(pos[1].split("\\?")[0]));
    }
}

