/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.ComException;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlavePriorities;
import org.neo4j.kernel.ha.com.master.SlavePriority;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.CappedOperation;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class MasterTxIdGenerator
implements TxIdGenerator,
Lifecycle {
    private int desiredReplicationFactor;
    private SlavePriority replicationStrategy;
    private ExecutorService slaveCommitters;
    private final StringLogger log;
    private final Configuration config;
    private final Slaves slaves;
    private final CappedOperation<Throwable> slaveCommitFailureLogger = new CappedOperation<Throwable>(new CappedOperation.Switch[]{CappedOperation.time((long)5L, (TimeUnit)TimeUnit.SECONDS), CappedOperation.differentItemClasses()}){

        protected void triggered(Throwable failure) {
            MasterTxIdGenerator.this.log.error("Slave commit threw " + (failure instanceof ComException ? "communication" : "") + " exception", failure);
        }
    };
    private final Map<Integer, BlockingQueue<PullUpdateFuture>> pullUpdateQueues = new HashMap<Integer, BlockingQueue<PullUpdateFuture>>();
    private final List<ExecutorService> pullUpdateWorkers = new ArrayList<ExecutorService>();

    public static Configuration from(final Config config) {
        return new Configuration(){

            @Override
            public int getTxPushFactor() {
                return (Integer)config.get(HaSettings.tx_push_factor);
            }

            @Override
            public InstanceId getServerId() {
                return (InstanceId)config.get(ClusterSettings.server_id);
            }

            @Override
            public SlavePriority getReplicationStrategy() {
                switch ((HaSettings.TxPushStrategy)((Object)config.get(HaSettings.tx_push_strategy))) {
                    case fixed: {
                        return SlavePriorities.fixed();
                    }
                    case round_robin: {
                        return SlavePriorities.roundRobin();
                    }
                }
                throw new RuntimeException("Unknown replication strategy ");
            }
        };
    }

    public static Configuration from(final Config config, final SlavePriority slavePriority) {
        return new Configuration(){

            @Override
            public int getTxPushFactor() {
                return (Integer)config.get(HaSettings.tx_push_factor);
            }

            @Override
            public InstanceId getServerId() {
                return (InstanceId)config.get(ClusterSettings.server_id);
            }

            @Override
            public SlavePriority getReplicationStrategy() {
                return slavePriority;
            }
        };
    }

    public MasterTxIdGenerator(Configuration config, StringLogger log, Slaves slaves) {
        this.config = config;
        this.log = log;
        this.slaves = slaves;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        this.slaveCommitters = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("slave-committer"));
        this.desiredReplicationFactor = this.config.getTxPushFactor();
        this.replicationStrategy = this.config.getReplicationStrategy();
    }

    public void stop() throws Throwable {
        this.slaveCommitters.shutdown();
        for (ExecutorService pullUpdateWorker : this.pullUpdateWorkers) {
            pullUpdateWorker.shutdownNow();
            pullUpdateWorker.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    public void shutdown() throws Throwable {
    }

    public long generate(XaDataSource dataSource, int identifier) throws XAException {
        return TxIdGenerator.DEFAULT.generate(dataSource, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void committed(XaDataSource dataSource, int identifier, long txId, Integer externalAuthorServerId) {
        int replicationFactor = this.desiredReplicationFactor;
        if (externalAuthorServerId != null) {
            --replicationFactor;
        }
        if (replicationFactor == 0) {
            return;
        }
        HashSet<Future<Void>> committers = new HashSet<Future<Void>>();
        try {
            int successfulReplications = 0;
            Iterator<Slave> iterator = this.filter(this.replicationStrategy.prioritize(this.slaves.getSlaves()).iterator(), externalAuthorServerId);
            CompletionNotifier notifier = new CompletionNotifier();
            for (int i = 0; i < replicationFactor && iterator.hasNext(); ++i) {
                committers.add(this.slaveCommitters.submit(this.slaveCommitter(dataSource, iterator.next(), txId, notifier)));
            }
            ArrayList<Future<Void>> toAdd = new ArrayList<Future<Void>>();
            ArrayList<Future> toRemove = new ArrayList<Future>();
            while (!committers.isEmpty() && successfulReplications < replicationFactor) {
                toAdd.clear();
                toRemove.clear();
                for (Future future : committers) {
                    if (!future.isDone()) continue;
                    if (this.isSuccessful(future)) {
                        ++successfulReplications;
                    } else if (iterator.hasNext()) {
                        toAdd.add(this.slaveCommitters.submit(this.slaveCommitter(dataSource, iterator.next(), txId, notifier)));
                    }
                    toRemove.add(future);
                }
                if (!toAdd.isEmpty()) {
                    committers.addAll(toAdd);
                }
                if (!toRemove.isEmpty()) {
                    committers.removeAll(toRemove);
                }
                if (committers.isEmpty()) continue;
                notifier.waitForAnyCompletion();
            }
            if (successfulReplications < replicationFactor) {
                this.log.logMessage("Transaction " + txId + " for " + dataSource.getName() + " couldn't commit on enough slaves, desired " + replicationFactor + ", but could only commit at " + successfulReplications);
            }
        }
        catch (Throwable t) {
            this.log.logMessage("Unknown error commit master transaction at slave", t);
        }
        finally {
            for (Future future : committers) {
                future.cancel(false);
            }
        }
    }

    private Iterator<Slave> filter(Iterator<Slave> slaves, final Integer externalAuthorServerId) {
        return externalAuthorServerId == null ? slaves : new FilteringIterator((Iterator)slaves, (Predicate)new Predicate<Slave>(){

            public boolean accept(Slave item) {
                return item.getServerId() != externalAuthorServerId.intValue();
            }
        });
    }

    private boolean isSuccessful(Future<Void> committer) {
        try {
            committer.get();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (ExecutionException e) {
            this.slaveCommitFailureLogger.event((Object)e.getCause());
            return false;
        }
        catch (CancellationException e) {
            return false;
        }
    }

    private Callable<Void> slaveCommitter(final XaDataSource dataSource, final Slave slave, final long txId, final CompletionNotifier notifier) {
        return new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                try {
                    MasterTxIdGenerator.this.commitAtSlave(dataSource, slave, txId);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    notifier.completed();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitAtSlave(final XaDataSource dataSource, Slave slave, long txId) {
        PullUpdateFuture pullRequest = new PullUpdateFuture(slave, txId);
        Map<Integer, BlockingQueue<PullUpdateFuture>> map = this.pullUpdateQueues;
        synchronized (map) {
            BlockingQueue<PullUpdateFuture> queue = this.pullUpdateQueues.get(slave.getServerId());
            if (queue == null) {
                queue = new ArrayBlockingQueue<PullUpdateFuture>(100);
                this.pullUpdateQueues.put(slave.getServerId(), queue);
                ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("pull-worker"));
                this.pullUpdateWorkers.add(executorService);
                final BlockingQueue<PullUpdateFuture> finalQueue = queue;
                executorService.submit(new Runnable(){
                    List<PullUpdateFuture> currentPulls = new ArrayList<PullUpdateFuture>();

                    /*
                     * Unable to fully structure code
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        try {
                            block4: while (true) {
                                this.currentPulls.clear();
                                this.currentPulls.add((PullUpdateFuture)finalQueue.take());
                                while ((pullRequest = (PullUpdateFuture)finalQueue.poll()) != null) {
                                    this.currentPulls.add(pullRequest);
                                }
                                try {
                                    pullUpdateFuture = this.currentPulls.get(0);
                                    response = pullUpdateFuture.getSlave().pullUpdates(dataSource.getName(), PullUpdateFuture.access$300(pullUpdateFuture));
                                    response.close();
                                    i$ = this.currentPulls.iterator();
                                    while (true) {
                                        if (!i$.hasNext()) continue block4;
                                        currentPull = i$.next();
                                        currentPull.done();
                                    }
                                }
                                catch (Exception e) {
                                    i$ = this.currentPulls.iterator();
                                    while (true) {
                                        if (i$.hasNext()) ** break;
                                        continue block4;
                                        currentPull = i$.next();
                                        currentPull.setException(e);
                                    }
                                }
                                break;
                            }
                        }
                        catch (InterruptedException var1_2) {
                            return;
                        }
                    }
                });
            }
            queue.offer(pullRequest);
        }
        try {
            pullRequest.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public int getCurrentMasterId() {
        return this.config.getServerId().toIntegerIndex();
    }

    public int getMyId() {
        return this.config.getServerId().toIntegerIndex();
    }

    private static class PullUpdateFuture
    extends FutureTask<Object> {
        private Slave slave;
        private long txId;

        public PullUpdateFuture(Slave slave, long txId) {
            super(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return null;
                }
            });
            this.slave = slave;
            this.txId = txId;
        }

        @Override
        public void done() {
            super.set(null);
            super.done();
        }

        @Override
        public void setException(Throwable t) {
            super.setException(t);
        }

        public Slave getSlave() {
            return this.slave;
        }

        private long getTxId() {
            return this.txId;
        }

        static /* synthetic */ long access$300(PullUpdateFuture x0) {
            return x0.getTxId();
        }
    }

    private static class CompletionNotifier {
        private boolean notified;

        private CompletionNotifier() {
        }

        synchronized void completed() {
            this.notified = true;
            this.notifyAll();
        }

        synchronized void waitForAnyCompletion() {
            if (!this.notified) {
                this.notified = false;
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            } else {
                this.notified = false;
            }
        }
    }

    public static interface Configuration {
        public int getTxPushFactor();

        public InstanceId getServerId();

        public SlavePriority getReplicationStrategy();
    }
}

