/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestClusterIndexDeletion {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenClusterWithCreatedIndexWhenDeleteIndexOnMasterThenIndexIsDeletedOnSlave() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("testCluster", true), MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), ":6001-6005", HaSettings.tx_push_factor.name(), "2"}));
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            Transaction tx = master.beginTx();
            master.index().forNodes("Test");
            tx.success();
            tx.finish();
            Assert.assertThat((Object)clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]).index().existsForNodes("Test"), (Matcher)CoreMatchers.equalTo((Object)true));
            tx = master.beginTx();
            master.index().forNodes("Test").delete();
            tx.success();
            tx.finish();
            Assert.assertThat((Object)clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]).index().existsForNodes("Test"), (Matcher)CoreMatchers.equalTo((Object)false));
        }
        finally {
            clusterManager.stop();
        }
    }
}

