/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.ManagedResource;
import org.neo4j.test.TargetDirectory;

public class HaKernelDataTest {
    @Rule
    public final ManagedResource<HighlyAvailableGraphDatabase> ha = new ManagedResource<HighlyAvailableGraphDatabase>(){

        @Override
        protected HighlyAvailableGraphDatabase createResource(TargetDirectory.TestDirectory dir) throws Exception {
            return (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(dir.directory().getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, ":5001").newGraphDatabase();
        }

        @Override
        protected void disposeResource(HighlyAvailableGraphDatabase resource) {
            resource.shutdown();
        }
    };

    @Test
    public void shouldReturnHaGraphDbFromKernelData() throws Exception {
        HighlyAvailableGraphDatabase haGraphDb = this.ha.getResource();
        KernelData kernelData = haGraphDb.getKernelData();
        Assert.assertSame((Object)kernelData.graphDatabase(), (Object)haGraphDb);
    }
}

