/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.ha.ClusterManager;
import org.neo4j.tooling.GlobalGraphOperations;

public class BiggerThanLogTxIT
extends AbstractClusterTest {
    @Test
    public void shouldHandleSlaveCommittingLargeTx() throws Exception {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        int initialNodeCount = IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)slave).getAllNodes());
        int nodeCount = this.commitLargeTx((GraphDatabaseService)slave);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount);
        this.commitSmallTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount + 1);
    }

    @Test
    public void shouldHandleMasterCommittingLargeTx() throws Exception {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        int initialNodeCount = IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)slave).getAllNodes());
        int nodeCount = this.commitLargeTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount);
        this.commitSmallTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + nodeCount + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitSmallTx(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private void assertAllMembersHasNodeCount(int expectedNodeCount) {
        for (HighlyAvailableGraphDatabase db : this.cluster.getAllMembers()) {
            Assert.assertEquals((long)expectedNodeCount, (long)IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int commitLargeTx(GraphDatabaseService db) {
        long rotationThreshold = Config.parseLongWithUnit((String)GraphDatabaseSettings.logical_log_rotation_threshold.getDefaultValue());
        int nodeCount = 100;
        byte[] arrayProperty = new byte[(int)(rotationThreshold / (long)nodeCount)];
        Transaction tx = db.beginTx();
        try {
            for (int i = 0; i < nodeCount; ++i) {
                Node node = db.createNode();
                node.setProperty("name", (Object)("big" + i));
                node.setProperty("data", (Object)arrayProperty);
            }
            tx.success();
            int n = nodeCount;
            return n;
        }
        finally {
            tx.finish();
        }
    }
}

