/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.ha.ClusterManager;

public class ClusterTopologyChangesIT
extends AbstractClusterTest {
    @Before
    public void setUp() {
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
    }

    @Test
    public void masterRejoinsAfterFailureAndReelection() throws Throwable {
        HighlyAvailableGraphDatabase initialMaster = this.cluster.getMaster();
        ClusterManager.RepairKit kit = this.cluster.fail(initialMaster);
        this.cluster.await(ClusterManager.masterAvailable(initialMaster));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        this.repairUsing(kit);
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        Assert.assertEquals((long)3L, (long)this.cluster.size());
    }

    @Test
    public void slaveShouldServeTxsAfterMasterLostQuorumWentToPendingAndThenQuorumWasRestored() throws Throwable {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        final HighlyAvailableGraphDatabase slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        final HighlyAvailableGraphDatabase slave2 = this.cluster.getAnySlave(slave1);
        final CountDownLatch slave1Left = new CountDownLatch(1);
        final CountDownLatch slave2Left = new CountDownLatch(1);
        ClusterTopologyChangesIT.clusterClientOf(master).addHeartbeatListener((HeartbeatListener)new HeartbeatListener.Adapter(){

            public void failed(InstanceId server) {
                if (ClusterTopologyChangesIT.instanceIdOf(slave1).equals((Object)server)) {
                    slave1Left.countDown();
                } else if (ClusterTopologyChangesIT.instanceIdOf(slave2).equals((Object)server)) {
                    slave2Left.countDown();
                }
            }
        });
        ClusterManager.RepairKit slave1RepairKit = this.cluster.fail(slave1);
        slave1Left.await();
        ClusterManager.RepairKit slave2RepairKit = this.cluster.fail(slave2);
        slave2Left.await();
        this.cluster.await((Predicate<ClusterManager.ManagedCluster>)Predicates.not(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0])));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING.toString(), (Object)master.getInstanceState());
        slave1RepairKit.repair();
        slave2RepairKit.repair();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(master));
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(slave1));
        Assert.assertNotNull((Object)ClusterTopologyChangesIT.createNodeOn(slave2));
    }

    @Override
    protected void configureClusterMember(GraphDatabaseBuilder builder, String clusterName, InstanceId serverId) {
        super.configureClusterMember(builder, clusterName, serverId);
        builder.setConfig(HaSettings.read_timeout, "1s");
        builder.setConfig(HaSettings.state_switch_timeout, "2s");
    }

    private void repairUsing(ClusterManager.RepairKit kit) throws Throwable {
        Iterable stoppedServices = (Iterable)ReflectionUtil.getPrivateField((Object)kit, (String)"stoppedServices", Iterable.class);
        for (Lifecycle service : stoppedServices) {
            if (service instanceof NetworkReceiver) continue;
            service.start();
        }
        Thread.sleep(2000L);
        for (Lifecycle service : stoppedServices) {
            if (!(service instanceof NetworkReceiver)) continue;
            service.start();
        }
    }

    private static ClusterClient clusterClientOf(HighlyAvailableGraphDatabase db) {
        return (ClusterClient)db.getDependencyResolver().resolveDependency(ClusterClient.class);
    }

    private static InstanceId instanceIdOf(HighlyAvailableGraphDatabase db) {
        return ClusterTopologyChangesIT.clusterClientOf(db).getServerId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node createNodeOn(HighlyAvailableGraphDatabase db) {
        Node node;
        Transaction tx = db.beginTx();
        try {
            node = db.createNode();
            node.setProperty("key", (Object)String.valueOf(System.currentTimeMillis()));
            tx.success();
        }
        finally {
            tx.finish();
        }
        return node;
    }
}

