/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.ha.ClusterManager;

public class HaLoggingIT
extends AbstractClusterTest {
    @Test
    public void logging_continues_after_role_switch() throws Exception {
        this.cluster.await(ClusterManager.masterSeesMembers(3));
        String logMessage = "Just a test for that logging continues as expected";
        HighlyAvailableGraphDatabase db = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        StringLogger logger = (StringLogger)db.getDependencyResolver().resolveDependency(StringLogger.class);
        logger.logMessage(logMessage, true);
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.cluster.shutdown(master);
        this.cluster.await(ClusterManager.masterAvailable(master));
        this.cluster.await(ClusterManager.masterSeesMembers(2));
        logger.logMessage(logMessage, true);
        int count = this.findLoggingLines(db, logMessage);
        Assert.assertEquals((long)2L, (long)count);
    }

    public HaLoggingIT() {
        super(ClusterManager.clusterWithAdditionalClients(2, 1));
    }

    private int findLoggingLines(HighlyAvailableGraphDatabase db, String toLookFor) {
        int count = 0;
        for (String line : IteratorUtil.asIterable((File)new File(this.cluster.getStoreDir(db), "messages.log"))) {
            if (!line.endsWith(toLookFor)) continue;
            ++count;
        }
        return count;
    }
}

