/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;

public class HANewSnapshotFunctionTest {
    @Test
    public void normalClusterCreationShouldBePassedUnchanged() throws Exception {
        LinkedList<MemberIsAvailable> events = new LinkedList<MemberIsAvailable>();
        events.add(this.roleForId("master", 1));
        events.add(this.roleForId("backup", 1));
        events.add(this.roleForId("slave", 2));
        events.add(this.roleForId("slave", 3));
        Iterable<Object> result = new LinkedList<MemberIsAvailable>();
        for (MemberIsAvailable event : events) {
            result = new HANewSnapshotFunction().apply(result, event);
        }
        this.eventsMatch(result, events);
    }

    @Test
    public void duplicateSlaveEventsShouldBeFilteredOut() throws Exception {
        LinkedList<MemberIsAvailable> events = new LinkedList<MemberIsAvailable>();
        events.add(this.roleForId("master", 1));
        events.add(this.roleForId("backup", 1));
        events.add(this.roleForId("slave", 2));
        events.add(this.roleForId("slave", 3));
        events.add(this.roleForId("slave", 2));
        events.add(this.roleForId("slave", 3));
        LinkedList<MemberIsAvailable> expected = new LinkedList<MemberIsAvailable>();
        expected.add(this.roleForId("master", 1));
        expected.add(this.roleForId("backup", 1));
        expected.add(this.roleForId("slave", 2));
        expected.add(this.roleForId("slave", 3));
        Iterable<Object> result = new LinkedList<MemberIsAvailable>();
        for (MemberIsAvailable event : events) {
            result = new HANewSnapshotFunction().apply(result, event);
        }
        this.eventsMatch(result, expected);
    }

    @Test
    public void instanceBeingMasterReappearsAsSlaveShouldBeTreatedAsSlave() throws Exception {
        LinkedList<MemberIsAvailable> events = new LinkedList<MemberIsAvailable>();
        events.add(this.roleForId("master", 1));
        events.add(this.roleForId("backup", 1));
        events.add(this.roleForId("slave", 2));
        events.add(this.roleForId("slave", 1));
        events.add(this.roleForId("slave", 3));
        LinkedList<MemberIsAvailable> expected = new LinkedList<MemberIsAvailable>();
        expected.add(this.roleForId("slave", 2));
        expected.add(this.roleForId("slave", 1));
        expected.add(this.roleForId("slave", 3));
        Iterable<Object> result = new LinkedList<MemberIsAvailable>();
        for (MemberIsAvailable event : events) {
            result = new HANewSnapshotFunction().apply(result, event);
        }
        this.eventsMatch(result, expected);
    }

    @Test
    public void instanceBeingSlaveReappearsAsMasterShouldBeTreatedAsMaster() throws Exception {
        LinkedList<MemberIsAvailable> events = new LinkedList<MemberIsAvailable>();
        events.add(this.roleForId("slave", 2));
        events.add(this.roleForId("slave", 1));
        events.add(this.roleForId("master", 1));
        events.add(this.roleForId("slave", 3));
        LinkedList<MemberIsAvailable> expected = new LinkedList<MemberIsAvailable>();
        expected.add(this.roleForId("slave", 2));
        expected.add(this.roleForId("master", 1));
        expected.add(this.roleForId("slave", 3));
        Iterable<Object> result = new LinkedList<MemberIsAvailable>();
        for (MemberIsAvailable event : events) {
            result = new HANewSnapshotFunction().apply(result, event);
        }
        this.eventsMatch(result, expected);
    }

    @Test
    public void instanceBeingMasterReplacedByAnotherInstanceShouldNotRemainMaster() throws Exception {
        LinkedList<MemberIsAvailable> events = new LinkedList<MemberIsAvailable>();
        events.add(this.roleForId("master", 1));
        events.add(this.roleForId("backup", 1));
        events.add(this.roleForId("master", 2));
        events.add(this.roleForId("slave", 3));
        LinkedList<MemberIsAvailable> expected = new LinkedList<MemberIsAvailable>();
        expected.add(this.roleForId("master", 2));
        expected.add(this.roleForId("slave", 3));
        Iterable<Object> result = new LinkedList<MemberIsAvailable>();
        for (MemberIsAvailable event : events) {
            result = new HANewSnapshotFunction().apply(result, event);
        }
        this.eventsMatch(result, expected);
    }

    private MemberIsAvailable roleForId(String role, int id) {
        return new MemberIsAvailable(role, new InstanceId(id), URI.create("cluster://" + id), URI.create("ha://" + id));
    }

    private void eventsMatch(Iterable<MemberIsAvailable> result, List<MemberIsAvailable> expected) {
        Iterator<MemberIsAvailable> iter = result.iterator();
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), (Object)iter.next());
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }
}

