/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cluster.InstanceId;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;

public class HighAvailabilityMemberStateTest {
    public static final URI SampleUri = URI.create("ha://foo");
    private InstanceId myId;
    private HighAvailabilityMemberContext context;

    @Before
    public void setup() {
        this.myId = new InstanceId(1);
        this.context = (HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class);
        Mockito.when((Object)this.context.getMyId()).thenReturn((Object)this.myId);
    }

    @Test
    public void testPendingMasterIsElected() {
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.PENDING.masterIsElected(this.context, this.myId);
        Assert.assertEquals((Object)HighAvailabilityMemberState.TO_MASTER, (Object)newState);
        HighAvailabilityMemberState newStateCase2 = HighAvailabilityMemberState.PENDING.masterIsElected(this.context, new InstanceId(2));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)newStateCase2);
    }

    @Test
    public void testPendingMasterIsAvailable() {
        try {
            HighAvailabilityMemberState.PENDING.masterIsAvailable(this.context, this.myId, SampleUri);
            Assert.fail((String)"Should not accept MasterIsAvailable for myself from PENDING");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.PENDING.masterIsAvailable(this.context, new InstanceId(2), SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.TO_SLAVE, (Object)newState);
    }

    @Test
    public void testPendingSlaveIsAvailable() {
        try {
            HighAvailabilityMemberState.PENDING.slaveIsAvailable(this.context, this.myId, SampleUri);
            Assert.fail((String)"Should not accept SlaveIsAvailable for myself from PENDING");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.PENDING.slaveIsAvailable(this.context, new InstanceId(2), SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)newState);
    }

    @Test
    public void testToMasterMasterIsElected() {
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.TO_MASTER.masterIsElected(this.context, this.myId);
        Assert.assertEquals((Object)HighAvailabilityMemberState.TO_MASTER, (Object)newState);
        HighAvailabilityMemberState newStateCase2 = HighAvailabilityMemberState.TO_MASTER.masterIsElected(this.context, new InstanceId(2));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)newStateCase2);
    }

    @Test
    public void testToMasterMasterIsAvailable() {
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.TO_MASTER.masterIsAvailable(this.context, this.myId, SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.MASTER, (Object)newState);
        try {
            HighAvailabilityMemberState.TO_MASTER.masterIsAvailable(this.context, new InstanceId(2), SampleUri);
            Assert.fail((String)"Should not accept MasterIsAvailable for someone else from TO_MASTER");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testToMasterSlaveIsAvailable() {
        try {
            HighAvailabilityMemberState.TO_MASTER.slaveIsAvailable(this.context, this.myId, SampleUri);
            Assert.fail((String)"Should not accept SlaveIsAvailable for me while in TO_MASTER");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.TO_MASTER.slaveIsAvailable(this.context, new InstanceId(2), SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.TO_MASTER, (Object)newState);
    }

    @Test
    public void testMasterMasterIsElected() {
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.MASTER.masterIsElected(this.context, this.myId);
        Assert.assertEquals((Object)HighAvailabilityMemberState.MASTER, (Object)newState);
        HighAvailabilityMemberState newStateCase2 = HighAvailabilityMemberState.MASTER.masterIsElected(this.context, new InstanceId(2));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)newStateCase2);
    }

    @Test
    public void testMasterMasterIsAvailable() {
        try {
            HighAvailabilityMemberState.MASTER.masterIsAvailable(this.context, new InstanceId(2), SampleUri);
            Assert.fail((String)"Should not allow master switch with missing masterIsElected");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.MASTER.masterIsAvailable(this.context, this.myId, SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.MASTER, (Object)newState);
    }

    @Test
    public void testMasterSlaveIsAvailable() {
        try {
            HighAvailabilityMemberState.MASTER.slaveIsAvailable(this.context, this.myId, SampleUri);
            Assert.fail((String)"MASTER to SLAVE is not allowed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.MASTER.slaveIsAvailable(this.context, new InstanceId(2), SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.MASTER, (Object)newState);
    }

    @Test
    public void testToSlaveMasterIsElected() {
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.TO_SLAVE.masterIsElected(this.context, this.myId);
        Assert.assertEquals((Object)HighAvailabilityMemberState.TO_MASTER, (Object)newState);
        HighAvailabilityMemberState newStateCase2 = HighAvailabilityMemberState.TO_SLAVE.masterIsElected(this.context, new InstanceId(2));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)newStateCase2);
    }

    @Test
    public void testToSlaveMasterIsAvailable() {
        try {
            HighAvailabilityMemberState.TO_SLAVE.masterIsAvailable(this.context, this.myId, SampleUri);
            Assert.fail((String)"TO_SLAVE to MASTER is not allowed");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        InstanceId currentMaster = new InstanceId(2);
        Mockito.when((Object)this.context.getElectedMasterId()).thenReturn((Object)currentMaster);
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.TO_SLAVE.masterIsAvailable(this.context, currentMaster, SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.TO_SLAVE, (Object)newState);
        try {
            HighAvailabilityMemberState.TO_SLAVE.masterIsAvailable(this.context, new InstanceId(3), SampleUri);
            Assert.fail((String)"Should have gotten an election result first");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testToSlaveSlaveIsAvailable() {
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.TO_SLAVE.slaveIsAvailable(this.context, this.myId, SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.SLAVE, (Object)newState);
        HighAvailabilityMemberState newStateCase2 = HighAvailabilityMemberState.TO_SLAVE.slaveIsAvailable(this.context, new InstanceId(2), SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.TO_SLAVE, (Object)newStateCase2);
    }

    @Test
    public void testSlaveMasterIsElected() {
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.SLAVE.masterIsElected(this.context, this.myId);
        Assert.assertEquals((Object)HighAvailabilityMemberState.TO_MASTER, (Object)newState);
        InstanceId masterInstanceId = new InstanceId(2);
        Mockito.when((Object)this.context.getElectedMasterId()).thenReturn((Object)masterInstanceId);
        HighAvailabilityMemberState newStateCase2 = HighAvailabilityMemberState.SLAVE.masterIsElected(this.context, new InstanceId(3));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)newStateCase2);
        HighAvailabilityMemberState newStateCase3 = HighAvailabilityMemberState.SLAVE.masterIsElected(this.context, masterInstanceId);
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)newStateCase3);
    }

    @Test
    public void testSlaveMasterIsAvailable() {
        try {
            HighAvailabilityMemberState.SLAVE.masterIsAvailable(this.context, this.myId, SampleUri);
            Assert.fail((String)"Should have gotten an election result first");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        InstanceId masterInstanceId = new InstanceId(2);
        Mockito.when((Object)this.context.getElectedMasterId()).thenReturn((Object)masterInstanceId);
        try {
            HighAvailabilityMemberState.SLAVE.masterIsAvailable(this.context, new InstanceId(3), SampleUri);
            Assert.fail((String)"Should have gotten an election result first");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HighAvailabilityMemberState newState = HighAvailabilityMemberState.SLAVE.masterIsAvailable(this.context, masterInstanceId, SampleUri);
        Assert.assertEquals((Object)HighAvailabilityMemberState.SLAVE, (Object)newState);
    }

    @Test
    public void testSlaveSlaveIsAvailable() {
        Assert.assertEquals((Object)HighAvailabilityMemberState.SLAVE, (Object)HighAvailabilityMemberState.SLAVE.slaveIsAvailable((HighAvailabilityMemberContext)Mockito.mock(HighAvailabilityMemberContext.class), (InstanceId)Mockito.mock(InstanceId.class), SampleUri));
    }
}

