/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.util.HashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.RequestContext;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;

public class MasterImplTest {
    @Test
    public void givenStartedAndInaccessibleWhenInitializeTxThenThrowException() throws Throwable {
        MasterImpl.SPI spi = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        DevNullLoggingService logging = new DevNullLoggingService();
        Config config = this.config(20);
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)false);
        MasterImpl instance = new MasterImpl(spi, (Logging)logging, config);
        instance.start();
        try {
            instance.initializeTx(new RequestContext(0L, 1, 2, new RequestContext.Tx[0], 1, 0L));
            junit.framework.Assert.fail();
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
    }

    @Test
    public void givenStartedAndAccessibleWhenInitializeTxThenSucceeds() throws Throwable {
        MasterImpl.SPI spi = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        DevNullLoggingService logging = new DevNullLoggingService();
        Config config = this.config(20);
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)true);
        Mockito.when((Object)spi.beginTx()).thenReturn(Mockito.mock(Transaction.class));
        Mockito.when((Object)spi.getMasterIdForCommittedTx(Matchers.anyLong())).thenReturn((Object)Pair.of((Object)1, (Object)1L));
        MasterImpl instance = new MasterImpl(spi, (Logging)logging, config);
        instance.start();
        HandshakeResult handshake = (HandshakeResult)instance.handshake(1L, new StoreId()).response();
        try {
            instance.initializeTx(new RequestContext(handshake.epoch(), 1, 2, new RequestContext.Tx[0], 1, 0L));
        }
        catch (Exception e) {
            junit.framework.Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void failingToStartTxShouldNotLeadToNPE() throws Throwable {
        MasterImpl.SPI spi = (MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class);
        Config config = this.config(20);
        Mockito.when((Object)spi.isAccessible()).thenReturn((Object)true);
        Mockito.when((Object)spi.beginTx()).thenThrow(new Throwable[]{new SystemException("Nope")});
        Mockito.when((Object)spi.getMasterIdForCommittedTx(Matchers.anyLong())).thenReturn((Object)Pair.of((Object)1, (Object)1L));
        MasterImpl instance = new MasterImpl(spi, (Logging)new DevNullLoggingService(), config);
        instance.start();
        HandshakeResult handshake = (HandshakeResult)instance.handshake(1L, new StoreId()).response();
        try {
            instance.initializeTx(new RequestContext(handshake.epoch(), 1, 2, new RequestContext.Tx[0], 1, 0L));
            junit.framework.Assert.fail((String)"Should have failed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(SystemException.class));
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Nope"));
        }
    }

    private Config config(int lockReadTimeout) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(HaSettings.lock_read_timeout.name(), lockReadTimeout + "s");
        params.put(ClusterSettings.server_id.name(), "1");
        return new Config(params, new Class[]{HaSettings.class});
    }
}

