/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class CSVFile
implements Closeable {
    private final OutputStream out;

    public CSVFile(OutputStream outStream, Iterable<String> columns) throws IOException {
        this.out = outStream;
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (String column : columns) {
            builder.append(separator);
            builder.append(column);
            separator = "\t";
        }
        builder.append('\n');
        this.out.write(builder.toString().getBytes(Charset.forName("UTF-8")));
    }

    public void print(Number ... values) throws IOException {
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (Number value : values) {
            builder.append(separator);
            builder.append(value.longValue());
            separator = "\t";
        }
        builder.append('\n');
        this.out.write(builder.toString().getBytes(Charset.forName("UTF-8")));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

