/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class BranchDetectingTxVerifier
implements TxChecksumVerifier {
    private final StringLogger logger;
    private XaDataSource dataSource;
    private DependencyResolver resolver;

    public BranchDetectingTxVerifier(DependencyResolver resolver) {
        this.resolver = resolver;
        this.logger = ((Logging)resolver.resolveDependency(Logging.class)).getMessagesLog(this.getClass());
    }

    public void assertMatch(long txId, int masterId, long checksum) {
        try {
            boolean match;
            Pair readChecksum = this.dataSource().getMasterForCommittedTx(txId);
            boolean bl = match = masterId == (Integer)readChecksum.first() && checksum == (Long)readChecksum.other();
            if (!match) {
                throw new BranchedDataException(this.stringify(txId, masterId, checksum) + " doesn't match " + readChecksum);
            }
        }
        catch (IOException e) {
            this.logger.logMessage("Couldn't verify checksum for " + this.stringify(txId, masterId, checksum), (Throwable)e);
            throw new BranchedDataException(e);
        }
    }

    private XaDataSource dataSource() {
        if (this.dataSource == null) {
            this.dataSource = ((XaDataSourceManager)this.resolver.resolveDependency(XaDataSourceManager.class)).getXaDataSource("nioneodb");
        }
        return this.dataSource;
    }

    private String stringify(long txId, int masterId, long checksum) {
        return "txId:" + txId + ", masterId:" + masterId + ", checksum:" + checksum;
    }
}

