/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.test.TargetDirectory;

@Ignore(value="There are no slave only instances yet")
public class TestSlaveOnlyCluster {
    private HighlyAvailableGraphDatabase master;
    private final HighlyAvailableGraphDatabase[] slaves = new HighlyAvailableGraphDatabase[2];
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public void doBefore() throws Exception {
    }

    @After
    public void doAfter() throws Exception {
        for (HighlyAvailableGraphDatabase db : this.slaves) {
            if (db == null) continue;
            db.shutdown();
        }
        this.master.shutdown();
    }

    @Test
    public void testMasterElectionAfterMasterRecoversInSlaveOnlyCluster() throws Exception {
        this.master.shutdown();
        Thread.sleep(1000L);
        while (!this.master.isMaster()) {
        }
        while (!this.slaves[0].getInstanceState().equals(HighAvailabilityMemberState.SLAVE)) {
        }
        while (!this.slaves[1].getInstanceState().equals(HighAvailabilityMemberState.SLAVE)) {
        }
        Transaction tx = this.slaves[0].beginTx();
        this.slaves[0].createNode();
        tx.success();
        tx.finish();
    }
}

