/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

public class TestPaxosClusterEvents {
    @Rule
    public LoggerRule logger = new LoggerRule();
    List<HighlyAvailableGraphDatabase> databases = new ArrayList<HighlyAvailableGraphDatabase>();
    public TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public void setup() throws IOException {
        HighlyAvailableGraphDatabase initialDatabase = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("1", true).getAbsolutePath()).setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(HaSettings.server_id, "1").setConfig(HaSettings.ha_server, "localhost:6361").newGraphDatabase();
        this.databases.add(initialDatabase);
        for (int i = 0; i < 2; ++i) {
            int serverId = i + 2;
            HighlyAvailableGraphDatabase database = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("" + serverId, true).getAbsolutePath()).setConfig(ClusterSettings.cluster_server, "localhost:" + (5002 + i)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(HaSettings.server_id, serverId + "").setConfig(HaSettings.ha_server, ":" + (6362 + i)).newGraphDatabase();
            this.databases.add(database);
        }
        this.logger.getLogger().info("*** All nodes started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHa() throws InterruptedException {
        long nodeId = 0L;
        Transaction tx = null;
        try {
            tx = this.databases.get(1).beginTx();
            Node node = this.databases.get(1).createNode();
            node.setProperty("Hello", (Object)"World");
            nodeId = node.getId();
            tx.success();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            Assert.fail();
        }
        finally {
            tx.finish();
        }
        while (true) {
            try {
                String value = this.databases.get(0).getNodeById(nodeId).getProperty("Hello").toString();
                this.logger.getLogger().info("Hello=" + value);
                Assert.assertEquals((String)"World", (String)value);
            }
            catch (Exception e) {
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    @After
    public void tearDown() {
        for (HighlyAvailableGraphDatabase database : this.databases) {
            database.shutdown();
        }
    }
}

