/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.GCResistantCache;
import org.neo4j.test.TargetDirectory;

public class TestEnterpriseCacheType {
    private String storeDir = TargetDirectory.forTest(this.getClass()).graphDbDir(true).getAbsolutePath();
    private GraphDatabaseAPI db;

    @Test
    public void defaultEmbeddedGraphDbShouldUseGcr() throws Exception {
        this.db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir);
        Assert.assertEquals(GCResistantCache.class, this.cacheTypeInUse(this.db));
    }

    @Test
    public void defaultHaGraphDbShouldUseGcr() throws Exception {
        this.db = (GraphDatabaseAPI)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.storeDir).setConfig(HaSettings.server_id, "1").newGraphDatabase();
        Assert.assertEquals(GCResistantCache.class, this.cacheTypeInUse(this.db));
    }

    @After
    public void after() throws Exception {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    private Class<?> cacheTypeInUse(GraphDatabaseAPI db) {
        return ((Cache)db.getNodeManager().caches().iterator().next()).getClass();
    }
}

