/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.index;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.IsCollectionContaining;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class AutoIndexConfigIT {
    private static final TargetDirectory dir = TargetDirectory.forTest(AutoIndexConfigIT.class);
    private ClusterManager.ManagedCluster cluster;
    private ClusterManager clusterManager;

    public void startCluster(int size) throws Throwable {
        this.clusterManager = new ClusterManager(ClusterManager.clusterOfSize(size), dir.directory("dbs", true), MapUtil.stringMap((String[])new String[0])){

            @Override
            protected void config(GraphDatabaseBuilder builder, String clusterName, int serverId) {
                builder.setConfig("jmx.port", "" + (9912 + serverId));
                builder.setConfig(HaSettings.ha_server, ":" + (1136 + serverId));
            }
        };
        this.clusterManager.start();
        this.cluster = this.clusterManager.getDefaultCluster();
    }

    @After
    public void stopCluster() throws Throwable {
        this.clusterManager.stop();
    }

    @Test
    public void programmaticConfigShouldSurviveMasterSwitches() throws Throwable {
        String propertyToIndex = "programmatic-property";
        this.startCluster(2);
        HighlyAvailableGraphDatabase originalMaster = this.cluster.getMaster();
        AutoIndexer originalAutoIndex = originalMaster.index().getNodeAutoIndexer();
        originalAutoIndex.setEnabled(true);
        originalAutoIndex.startAutoIndexingProperty(propertyToIndex);
        ClusterManager.RepairKit originalMasterRepairKit = this.cluster.shutdown(originalMaster);
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        originalMasterRepairKit.repair();
        AutoIndexer newAutoIndex = originalMaster.index().getNodeAutoIndexer();
        Assert.assertThat((Object)newAutoIndex.isEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newAutoIndex.getAutoIndexedProperties(), (Matcher)IsCollectionContaining.hasItem((Object)propertyToIndex));
    }
}

