/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.test.TargetDirectory;

public abstract class ManagedResource<R>
implements TestRule {
    private R resource;

    public final R getResource() {
        R result = this.resource;
        if (result == null) {
            throw new IllegalStateException("Resource is not started.");
        }
        return result;
    }

    protected abstract R createResource(TargetDirectory.TestDirectory var1) throws Exception;

    protected abstract void disposeResource(R var1);

    public final Statement apply(final Statement base, Description description) {
        final TargetDirectory.TestDirectory dir = TargetDirectory.forTest((Class)description.getTestClass()).testDirectory();
        return dir.apply(new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ManagedResource.this.resource = ManagedResource.this.createResource(dir);
                try {
                    base.evaluate();
                }
                finally {
                    Object waste = ManagedResource.this.resource;
                    ManagedResource.this.resource = null;
                    ManagedResource.this.disposeResource(waste);
                }
            }
        }, description);
    }
}

