/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.InstanceAccessGuard;
import org.neo4j.kernel.ha.TransactionSupport;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

class DefaultTransactionSupport
extends LifecycleAdapter
implements TransactionSupport {
    private final AbstractTransactionManager txManager;
    private final TxHook txHook;
    private final InstanceAccessGuard switchBlock;
    private final Config config;
    private long stateSwitchTimeout;

    DefaultTransactionSupport(AbstractTransactionManager txManager, TxHook txHook, InstanceAccessGuard switchBlock, Config config) {
        this.txManager = txManager;
        this.txHook = txHook;
        this.switchBlock = switchBlock;
        this.config = config;
    }

    public void start() throws Throwable {
        this.stateSwitchTimeout = (Long)this.config.get(HaSettings.state_switch_timeout);
    }

    @Override
    public boolean hasAnyLocks(Transaction tx) {
        return this.txManager.getTransactionState().hasLocks();
    }

    @Override
    public void makeSureTxHasBeenInitialized() {
        try {
            Transaction tx = this.txManager.getTransaction();
            int eventIdentifier = this.txManager.getEventIdentifier();
            if (!this.hasAnyLocks(tx)) {
                if (!this.switchBlock.await(this.stateSwitchTimeout)) {
                    throw new RuntimeException("Timed out waiting for database to switch state");
                }
                this.txHook.initializeTransaction(eventIdentifier);
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }
}

