/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.HaRequestType17;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.UnableToResumeTransactionException;
import org.neo4j.kernel.impl.nioneo.store.IdRange;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.logging.Logging;

public class MasterClient17
extends Client<Master>
implements MasterClient {
    public static final byte PROTOCOL_VERSION = 3;
    private final int lockReadTimeout;

    public MasterClient17(String hostNameOrIp, int port, Logging logging, StoreId storeId, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
        super(hostNameOrIp, port, logging, storeId, 0x1000000, (byte)3, (long)readTimeoutSeconds, maxConcurrentChannels, Math.min(maxConcurrentChannels, 20), chunkSize);
        this.lockReadTimeout = lockReadTimeout;
    }

    protected long getReadTimeout(RequestType<Master> type, long readTimeout) {
        return ((HaRequestType17)type).isLock() ? (long)this.lockReadTimeout : readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<Master> type) {
        return type != HaRequestType17.COPY_STORE;
    }

    @Override
    public Response<IdAllocation> allocateIds(final IdType idType) {
        return this.sendRequest(HaRequestType17.ALLOCATE_IDS, RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                buffer.writeByte(idType.ordinal());
            }
        }, (Deserializer)new Deserializer<IdAllocation>(){

            public IdAllocation read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return MasterClient17.readIdAllocation(buffer);
            }
        });
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, final String name) {
        return this.sendRequest(HaRequestType17.CREATE_RELATIONSHIP_TYPE, context, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Void> initializeTx(RequestContext context) {
        return this.sendRequest(HaRequestType17.INITIALIZE_TX, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireNodeWriteLock(RequestContext context, long ... nodes) {
        return this.sendRequest(HaRequestType17.ACQUIRE_NODE_WRITE_LOCK, context, new AcquireLockSerializer(nodes), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireNodeReadLock(RequestContext context, long ... nodes) {
        return this.sendRequest(HaRequestType17.ACQUIRE_NODE_READ_LOCK, context, new AcquireLockSerializer(nodes), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(RequestContext context, long ... relationships) {
        return this.sendRequest(HaRequestType17.ACQUIRE_RELATIONSHIP_WRITE_LOCK, context, new AcquireLockSerializer(relationships), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireRelationshipReadLock(RequestContext context, long ... relationships) {
        return this.sendRequest(HaRequestType17.ACQUIRE_RELATIONSHIP_READ_LOCK, context, new AcquireLockSerializer(relationships), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireGraphWriteLock(RequestContext context) {
        return this.sendRequest(HaRequestType17.ACQUIRE_GRAPH_WRITE_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireGraphReadLock(RequestContext context) {
        return this.sendRequest(HaRequestType17.ACQUIRE_GRAPH_READ_LOCK, context, Protocol.EMPTY_SERIALIZER, LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireIndexReadLock(RequestContext context, String index, String key) {
        return this.sendRequest(HaRequestType17.ACQUIRE_INDEX_READ_LOCK, context, new AcquireIndexLockSerializer(index, key), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireIndexWriteLock(RequestContext context, String index, String key) {
        return this.sendRequest(HaRequestType17.ACQUIRE_INDEX_WRITE_LOCK, context, new AcquireIndexLockSerializer(index, key), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<Long> commitSingleResourceTransaction(RequestContext context, final String resource, final TxExtractor txGetter) {
        return this.sendRequest(HaRequestType17.COMMIT, context, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)resource);
                BlockLogBuffer blockLogBuffer = new BlockLogBuffer(buffer);
                txGetter.extract((LogBuffer)blockLogBuffer);
                blockLogBuffer.done();
            }
        }, (Deserializer)new Deserializer<Long>(){

            public Long read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readLong();
            }
        });
    }

    @Override
    public Response<Void> finishTransaction(RequestContext context, final boolean success) {
        try {
            return this.sendRequest(HaRequestType17.FINISH, context, new Serializer(){

                public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                    buffer.writeByte(success ? 1 : 0);
                }
            }, Protocol.VOID_DESERIALIZER);
        }
        catch (UnableToResumeTransactionException e) {
            if (!success) {
                return new Response(null, this.getStoreId(), TransactionStream.EMPTY, ResourceReleaser.NO_OP);
            }
            throw e;
        }
    }

    @Override
    public void rollbackOngoingTransactions(RequestContext context) {
        throw new UnsupportedOperationException("Should never be called from the client side");
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.sendRequest(HaRequestType17.PULL_UPDATES, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<Pair<Integer, Long>> getMasterIdForCommittedTx(final long txId, StoreId storeId) {
        return this.sendRequest(HaRequestType17.GET_MASTER_ID_FOR_TX, RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                buffer.writeLong(txId);
            }
        }, (Deserializer)new Deserializer<Pair<Integer, Long>>(){

            public Pair<Integer, Long> read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return Pair.of((Object)buffer.readInt(), (Object)buffer.readLong());
            }
        }, storeId);
    }

    @Override
    public Response<Void> copyStore(RequestContext context, StoreWriter writer) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(HaRequestType17.COPY_STORE, context, Protocol.EMPTY_SERIALIZER, (Deserializer)new Protocol.FileStreamsDeserializer(writer));
    }

    private RequestContext stripFromTransactions(RequestContext context) {
        return new RequestContext(context.getSessionId(), context.machineId(), context.getEventIdentifier(), new RequestContext.Tx[0], context.getMasterId(), context.getChecksum());
    }

    @Override
    public Response<Void> copyTransactions(RequestContext context, final String ds, final long startTxId, final long endTxId) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(HaRequestType17.COPY_TRANSACTIONS, context, new Serializer(){

            public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)ds);
                buffer.writeLong(startTxId);
                buffer.writeLong(endTxId);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<Void> pushTransaction(RequestContext context, String resourceName, long tx) {
        return Response.EMPTY;
    }

    protected static IdAllocation readIdAllocation(ChannelBuffer buffer) {
        int numberOfDefragIds = buffer.readInt();
        long[] defragIds = new long[numberOfDefragIds];
        for (int i = 0; i < numberOfDefragIds; ++i) {
            defragIds[i] = buffer.readLong();
        }
        long rangeStart = buffer.readLong();
        int rangeLength = buffer.readInt();
        long highId = buffer.readLong();
        long defragCount = buffer.readLong();
        return new IdAllocation(new IdRange(defragIds, rangeStart, rangeLength), highId, defragCount);
    }

    static abstract class AquireLockCall
    implements TargetCaller<Master, LockResult> {
        AquireLockCall() {
        }

        public Response<LockResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
            long[] ids = new long[input.readInt()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = input.readLong();
            }
            return this.lock(master, context, ids);
        }

        abstract Response<LockResult> lock(Master var1, RequestContext var2, long ... var3);
    }

    protected static class AcquireIndexLockSerializer
    implements Serializer {
        private final String index;
        private final String key;

        AcquireIndexLockSerializer(String index, String key) {
            this.index = index;
            this.key = key;
        }

        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
            Protocol.writeString((ChannelBuffer)buffer, (String)this.index);
            Protocol.writeString((ChannelBuffer)buffer, (String)this.key);
        }
    }

    protected static class AcquireLockSerializer
    implements Serializer {
        private final long[] entities;

        AcquireLockSerializer(long ... entities) {
            this.entities = entities;
        }

        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
            buffer.writeInt(this.entities.length);
            for (long entity : this.entities) {
                buffer.writeLong(entity);
            }
        }
    }
}

