/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.TransactionManager;
import org.neo4j.com.Response;
import org.neo4j.kernel.ha.HaXaDataSourceManager;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.RequestContextFactory;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class SlaveRelationshipTypeCreator
implements RelationshipTypeCreator {
    private Master master;
    private final RequestContextFactory requestContextFactory;
    private final HaXaDataSourceManager xaDsm;

    public SlaveRelationshipTypeCreator(Master master, RequestContextFactory requestContextFactory, HaXaDataSourceManager xaDsm) {
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.xaDsm = xaDsm;
    }

    public int getOrCreate(TransactionManager txManager, EntityIdGenerator idGenerator, PersistenceManager persistence, RelationshipTypeHolder relTypeHolder, String name) {
        Response<Integer> response = this.master.createRelationshipType(this.requestContextFactory.newRequestContext(), name);
        this.xaDsm.applyTransactions(response);
        return (Integer)response.response();
    }
}

