/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToFileStoreWriter;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.FileUtils;

public class SlaveStoreWriter {
    public static final String COPY_FROM_MASTER_TEMP = "temp-copy";
    private final Config config;

    public SlaveStoreWriter(Config config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStore(Master master) throws IOException {
        File storeDir = (File)this.config.get(InternalAbstractGraphDatabase.Configuration.store_dir);
        File tempStore = new File(storeDir, COPY_FROM_MASTER_TEMP);
        if (!tempStore.mkdir()) {
            FileUtils.deleteRecursively((File)tempStore);
            tempStore.mkdir();
        }
        Response<Void> response = master.copyStore(new RequestContext(0L, ((Integer)this.config.get(HaSettings.server_id)).intValue(), 0, new RequestContext.Tx[0], 0, 0L), (StoreWriter)new ToFileStoreWriter(tempStore));
        long highestLogVersion = XaLogicalLog.getHighestHistoryLogVersion((File)tempStore, (String)"nioneo_logical.log");
        if (highestLogVersion > -1L) {
            NeoStore.setVersion((File)tempStore, (long)(highestLogVersion + 1L));
        }
        GraphDatabaseAPI copiedDb = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(tempStore.getAbsolutePath()).setConfig((Setting)GraphDatabaseSettings.keep_logical_logs, "true").setConfig((Setting)GraphDatabaseSettings.allow_store_upgrade, ((Boolean)this.config.get((Setting)GraphDatabaseSettings.allow_store_upgrade)).toString()).newGraphDatabase();
        try {
            ServerUtil.applyReceivedTransactions(response, (XaDataSourceManager)copiedDb.getXaDataSourceManager(), (ServerUtil.TxHandler)ServerUtil.txHandlerForFullCopy());
        }
        finally {
            copiedDb.shutdown();
            response.close();
        }
        for (File candidate : tempStore.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("messages.log") && !"active_tx_log tm_tx_log.1 tm_tx_log.2".contains(file.getName());
            }
        })) {
            FileUtils.moveFileToDirectory((File)candidate, (File)storeDir);
        }
    }
}

