/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.helpers.Listeners;
import org.neo4j.kernel.ha.InstanceAccessGuard;
import org.neo4j.kernel.ha.cluster.HighAvailability;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class HighAvailabilityMemberStateMachine
extends LifecycleAdapter
implements HighAvailability {
    private final HighAvailabilityMemberContext context;
    private final InstanceAccessGuard accessGuard;
    private final ClusterMemberEvents events;
    private StringLogger logger;
    private Iterable<HighAvailabilityMemberListener> memberListeners = Listeners.newListeners();
    private HighAvailabilityMemberState state;
    private StateMachineClusterEventListener eventsListener;

    public HighAvailabilityMemberStateMachine(HighAvailabilityMemberContext context, InstanceAccessGuard accessGuard, ClusterMemberEvents events, StringLogger logger) {
        this.context = context;
        this.accessGuard = accessGuard;
        this.events = events;
        this.logger = logger;
        this.state = HighAvailabilityMemberState.PENDING;
    }

    public void init() throws Throwable {
        this.eventsListener = new StateMachineClusterEventListener();
        this.events.addClusterMemberListener((ClusterMemberListener)this.eventsListener);
    }

    public void stop() throws Throwable {
        this.events.removeClusterMemberListener((ClusterMemberListener)this.eventsListener);
        HighAvailabilityMemberState oldState = this.state;
        this.state = HighAvailabilityMemberState.PENDING;
        final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, this.state, null, null);
        Listeners.notifyListeners(this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

            public void notify(HighAvailabilityMemberListener listener) {
                listener.instanceStops(event);
            }
        });
        this.accessGuard.setState(this.state);
    }

    @Override
    public void addHighAvailabilityMemberListener(HighAvailabilityMemberListener toAdd) {
        this.memberListeners = Listeners.addListener((Object)toAdd, this.memberListeners);
    }

    @Override
    public void removeHighAvailabilityMemberListener(HighAvailabilityMemberListener toRemove) {
        this.memberListeners = Listeners.removeListener((Object)toRemove, this.memberListeners);
    }

    public HighAvailabilityMemberState getCurrentState() {
        return this.state;
    }

    private class StateMachineClusterEventListener
    extends ClusterMemberListener.Adapter {
        private StateMachineClusterEventListener() {
        }

        public synchronized void masterIsElected(URI masterUri) {
            try {
                HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                URI previousElected = HighAvailabilityMemberStateMachine.this.context.getElectedMasterId();
                HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberStateMachine.this.state.masterIsElected(HighAvailabilityMemberStateMachine.this.context, masterUri);
                HighAvailabilityMemberStateMachine.this.context.setElectedMasterId(masterUri);
                final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, masterUri, null);
                Listeners.notifyListeners((Iterable)HighAvailabilityMemberStateMachine.this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

                    public void notify(HighAvailabilityMemberListener listener) {
                        listener.masterIsElected(event);
                    }
                });
                HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(null);
                HighAvailabilityMemberStateMachine.this.accessGuard.setState(HighAvailabilityMemberStateMachine.this.state);
                HighAvailabilityMemberStateMachine.this.logger.debug("Got masterIsElected(" + masterUri + "), moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState) + ". Previous elected master is " + previousElected);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public synchronized void memberIsAvailable(String role, URI instanceClusterUri, URI roleUri) {
            try {
                if (role.equals("master")) {
                    if (!roleUri.equals(HighAvailabilityMemberStateMachine.this.context.getAvailableHaMaster())) {
                        HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                        HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(roleUri);
                        HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberStateMachine.this.state.masterIsAvailable(HighAvailabilityMemberStateMachine.this.context, instanceClusterUri, roleUri);
                        HighAvailabilityMemberStateMachine.this.logger.debug("Got masterIsAvailable(" + instanceClusterUri + ", moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState));
                        final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, instanceClusterUri, roleUri);
                        Listeners.notifyListeners((Iterable)HighAvailabilityMemberStateMachine.this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

                            public void notify(HighAvailabilityMemberListener listener) {
                                listener.masterIsAvailable(event);
                            }
                        });
                        HighAvailabilityMemberStateMachine.this.accessGuard.setState(HighAvailabilityMemberStateMachine.this.state);
                    }
                } else if (role.equals("slave")) {
                    HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                    HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberStateMachine.this.state.slaveIsAvailable(HighAvailabilityMemberStateMachine.this.context, instanceClusterUri);
                    HighAvailabilityMemberStateMachine.this.logger.debug("Got slaveIsAvailable(" + instanceClusterUri + "), " + "moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState));
                    final HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, instanceClusterUri, roleUri);
                    Listeners.notifyListeners((Iterable)HighAvailabilityMemberStateMachine.this.memberListeners, (Listeners.Notification)new Listeners.Notification<HighAvailabilityMemberListener>(){

                        public void notify(HighAvailabilityMemberListener listener) {
                            listener.slaveIsAvailable(event);
                        }
                    });
                    HighAvailabilityMemberStateMachine.this.accessGuard.setState(HighAvailabilityMemberStateMachine.this.state);
                }
            }
            catch (Throwable throwable) {
                HighAvailabilityMemberStateMachine.this.logger.warn("Exception while receiving member availability notification", throwable);
            }
        }
    }
}

