/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class DeletionTest {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.forTest(this.getClass()).cleanTestDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeleteRecords() throws Exception {
        Relationship rel;
        HighlyAvailableGraphDatabase slave;
        HighlyAvailableGraphDatabase master;
        HighlyAvailableGraphDatabase db1 = DeletionTest.start(this.testDirectory.directory().getPath() + "/db1", 0, MapUtil.stringMap((String[])new String[0]));
        HighlyAvailableGraphDatabase db2 = DeletionTest.start(this.testDirectory.directory().getPath() + "/db2", 1, MapUtil.stringMap((String[])new String[0]));
        if (db1.isMaster()) {
            master = db1;
            slave = db2;
        } else if (db2.isMaster()) {
            master = db2;
            slave = db1;
        } else {
            throw new AssertionError((Object)"NO MASTER");
        }
        Assert.assertFalse((String)"Two masters", (boolean)slave.isMaster());
        Transaction tx = slave.beginTx();
        try {
            rel = slave.createNode().createRelationshipTo(slave.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertNotNull((Object)master.getRelationshipById(rel.getId()));
        tx = slave.beginTx();
        try {
            rel.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
        slave.shutdown();
        master.shutdown();
    }

    private static HighlyAvailableGraphDatabase start(String storeDir, int i, Map<String, String> additionalConfig) {
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + i)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(HaSettings.server_id, i + "").setConfig(HaSettings.ha_server, "127.0.0.1:" + (6666 + i)).setConfig(HaSettings.pull_interval, "0ms").setConfig(additionalConfig).newGraphDatabase();
        DeletionTest.awaitStart(db);
        return db;
    }

    private static void awaitStart(HighlyAvailableGraphDatabase db) {
        db.beginTx().finish();
    }
}

