/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class TestItAll {
    private TargetDirectory PATH;
    private HighlyAvailableGraphDatabase[] databases;

    @Before
    public void before() throws Exception {
        this.PATH = TargetDirectory.forTest(this.getClass());
        this.PATH.cleanup();
    }

    @After
    public void after() throws Exception {
        for (HighlyAvailableGraphDatabase database : this.databases) {
            database.shutdown();
        }
    }

    @Test
    public void slaveCreateNode() throws Exception {
        this.startDbs(2);
        int master = this.getMaster();
        this.createNode((master + 1) % 2, "Slave node");
        this.assertNodesExists(0, "Slave node");
        this.assertNodesExists(1, "Slave node");
    }

    private void startDbs(int count) {
        this.databases = new HighlyAvailableGraphDatabase[count];
        for (int i = 0; i < count; ++i) {
            this.startDb(i);
        }
    }

    private HighlyAvailableGraphDatabase startDb(int serverId) {
        HighlyAvailableGraphDatabase database;
        this.databases[serverId] = database = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.path(serverId)).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + serverId)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(HaSettings.server_id, "" + serverId).setConfig(HaSettings.ha_server, "127.0.0.1:" + (8001 + serverId)).newGraphDatabase();
        return database;
    }

    private String path(int serverId) {
        return this.PATH.directory("" + serverId, false).getAbsolutePath();
    }

    private void createNode(int id, String name) {
        HighlyAvailableGraphDatabase db = this.databases[id];
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        db.getReferenceNode().createRelationshipTo(node, (RelationshipType)Types.TEST);
        node.setProperty("name", (Object)name);
        tx.success();
        tx.finish();
    }

    private int getMaster() {
        for (int i = 0; i < this.databases.length; ++i) {
            if (!this.databases[i].isMaster()) continue;
            return i;
        }
        Assert.fail((String)"No master");
        return -1;
    }

    private void assertNodesExists(int id, String ... names) {
        HighlyAvailableGraphDatabase db = this.databases[id];
        HashSet<String> expectation = new HashSet<String>(Arrays.asList(names));
        for (Relationship rel : db.getReferenceNode().getRelationships()) {
            String name = (String)rel.getEndNode().getProperty("name");
            Assert.assertTrue((String)("Found unexpected name " + name), (boolean)expectation.remove(name));
        }
        Assert.assertTrue((String)("Expected entries not encountered: " + expectation), (boolean)expectation.isEmpty());
    }

    private static enum Types implements RelationshipType
    {
        TEST;

    }
}

