/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.test.TargetDirectory;

public class TestMasterElection {
    private final File path = TargetDirectory.forTest(this.getClass()).graphDbDir(true);
    private HighlyAvailableGraphDatabase master;
    private HighlyAvailableGraphDatabase slave1;
    private HighlyAvailableGraphDatabase slave2;
    private CountDownLatch masterElectedLatch;

    @Before
    public void buildDbs() {
        this.master = this.startDb(0);
        this.slave1 = this.startDb(1);
        this.slave2 = this.startDb(2);
    }

    @After
    public void killDbs() {
        if (this.slave2 != null) {
            this.slave2.shutdown();
        }
        if (this.slave1 != null) {
            this.slave1.shutdown();
        }
        if (this.master != null) {
            this.master.shutdown();
        }
    }

    @Test
    public void testBasicFailover() throws Exception {
        Assert.assertTrue((boolean)this.master.isMaster());
        Assert.assertTrue((!this.slave1.isMaster() ? 1 : 0) != 0);
        Assert.assertTrue((!this.slave2.isMaster() ? 1 : 0) != 0);
        this.startListenForNewMaster(this.slave2);
        this.master.shutdown();
        this.master = null;
        Assert.assertTrue((boolean)this.masterElectedLatch.await(30L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.slave1.isMaster());
        Assert.assertTrue((!this.slave2.isMaster() ? 1 : 0) != 0);
    }

    private void startListenForNewMaster(HighlyAvailableGraphDatabase db) {
        this.masterElectedLatch = new CountDownLatch(1);
        final ClusterMemberEvents events = (ClusterMemberEvents)db.getDependencyResolver().resolveDependency(ClusterMemberEvents.class);
        events.addClusterMemberListener((ClusterMemberListener)new ClusterMemberListener.Adapter(){

            public void memberIsAvailable(String role, URI instanceClusterUri, URI roleUri) {
                if (role.equals("master")) {
                    TestMasterElection.this.masterElectedLatch.countDown();
                    events.removeClusterMemberListener((ClusterMemberListener)this);
                }
            }
        });
    }

    private HighlyAvailableGraphDatabase startDb(int serverId) {
        GraphDatabaseBuilder builder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.path(serverId)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001,127.0.0.1:5002,127.0.0.1:5003").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + serverId)).setConfig(HaSettings.server_id, "" + serverId).setConfig(HaSettings.ha_server, ":" + (8001 + serverId)).setConfig(HaSettings.tx_push_factor, "0").setConfig((Setting)GraphDatabaseSettings.intercept_committing_transactions, "true").setConfig((Setting)GraphDatabaseSettings.intercept_deserialized_transactions, "true").setConfig(TransactionInterceptorProvider.class.getSimpleName() + "." + "verifying", "true");
        return (HighlyAvailableGraphDatabase)builder.newGraphDatabase();
    }

    private String path(int i) {
        return new File(this.path, "" + i).getAbsolutePath();
    }
}

