/*
 * Decompiled with CFR 0.152.
 */
package recovery;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.TxLog;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.AbstractSubProcessTestBase;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.KillSubProcess;

@Ignore
public class TestDoubleRecovery
extends AbstractSubProcessTestBase {
    private static final byte[] NEOKERNL = new byte[]{78, 69, 79, 75, 69, 82, 78, 76, 0};
    private final CountDownLatch afterWrite = new CountDownLatch(1);
    private final CountDownLatch afterCrash = new CountDownLatch(1);
    private final BreakPoint ON_CRASH = new BreakPoint(Crash.class, "run", new Class[]{GraphDatabaseAPI.class}){

        protected void callback(DebugInterface debug) throws KillSubProcess {
            TestDoubleRecovery.this.afterCrash.countDown();
            throw KillSubProcess.withExitCode((int)-1);
        }
    };
    private final BreakPoint BEFORE_ANY_DATASOURCE_2PC = new BreakPoint(XaResourceHelpImpl.class, "commit", new Class[]{Xid.class, Boolean.TYPE}){

        protected void callback(DebugInterface debug) throws KillSubProcess {
            if (this.twoPhaseCommitIn(debug.thread())) {
                debug.thread().suspend(null);
                this.disable();
                TestDoubleRecovery.this.afterWrite.countDown();
                throw KillSubProcess.withExitCode((int)-1);
            }
        }

        private boolean twoPhaseCommitIn(DebuggedThread thread) {
            return !Boolean.parseBoolean(thread.getLocal(1, "onePhase"));
        }
    };
    private final BreakPoint BEFORE_SECOND_1PC = new BreakPoint(XaResourceHelpImpl.class, "commit", new Class[]{Xid.class, Boolean.TYPE}){
        private int counter;

        protected void callback(DebugInterface debug) throws KillSubProcess {
            if (this.onePhaseCommitIn(debug.thread()) && ++this.counter == 2) {
                debug.thread().suspend(null);
                this.disable();
                TestDoubleRecovery.this.afterWrite.countDown();
                throw KillSubProcess.withExitCode((int)-1);
            }
        }

        private boolean onePhaseCommitIn(DebuggedThread thread) {
            return Boolean.parseBoolean(thread.getLocal(1, "onePhase"));
        }
    };
    private final BreakPoint[] breakpointsForBefore2PC = new BreakPoint[]{this.ON_CRASH, this.BEFORE_ANY_DATASOURCE_2PC};
    private final AbstractSubProcessTestBase.Bootstrapper bootstrap = TestDoubleRecovery.bootstrap(this, MapUtil.stringMap((String[])new String[]{OnlineBackupSettings.online_backup_enabled.name(), "true"}));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crashAfter2PCMarkAsCommittingThenCrashAgainAndRecover() throws Exception {
        String backupDirectory = "target/var/backup-db";
        FileUtils.deleteRecursively((File)new File(backupDirectory));
        OnlineBackup.from((String)InetAddress.getLocalHost().getHostAddress()).full(backupDirectory);
        for (BreakPoint bp : this.breakpoints(0)) {
            bp.enable();
        }
        this.runInThread(new WriteTransaction());
        this.afterWrite.await();
        this.startSubprocesses();
        this.runInThread(new Crash());
        this.afterCrash.await();
        this.startSubprocesses();
        OnlineBackup.from((String)InetAddress.getLocalHost().getHostAddress()).incremental(backupDirectory);
        this.run(new Verification());
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(backupDirectory);
        try {
            new Verification().run((GraphDatabaseAPI)db);
        }
        finally {
            db.shutdown();
        }
    }

    protected BreakPoint[] breakpoints(int id) {
        return this.breakpointsForBefore2PC;
    }

    protected AbstractSubProcessTestBase.Bootstrapper bootstrap(int id) throws IOException {
        return this.bootstrap;
    }

    private static AbstractSubProcessTestBase.Bootstrapper bootstrap(TestDoubleRecovery test, Map<String, String> config) {
        try {
            return new AbstractSubProcessTestBase.Bootstrapper(test, 0, config){

                protected void shutdown(GraphDatabaseService graphdb, boolean normal) {
                    if (normal) {
                        super.shutdown(graphdb, normal);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        EmbeddedGraphDatabase graphdb = new EmbeddedGraphDatabase("target/test-data/junk");
        try {
            new WriteTransaction().run((GraphDatabaseAPI)graphdb);
        }
        finally {
            graphdb.shutdown();
        }
        TxLog log = new TxLog(new File(args[0]), (FileSystemAbstraction)new DefaultFileSystemAbstraction());
        byte[] globalId = new byte[NEOKERNL.length + 16];
        System.arraycopy(NEOKERNL, 0, globalId, 0, NEOKERNL.length);
        ByteBuffer byteBuf = ByteBuffer.wrap(globalId);
        byteBuf.position(NEOKERNL.length);
        byteBuf.putLong(Long.parseLong(args[1])).putLong(Long.parseLong(args[2]));
        log.txStart(globalId);
        log.addBranch(globalId, UTF8.encode((String)"414141"));
        log.addBranch(globalId, LuceneDataSource.DEFAULT_BRANCH_ID);
        log.markAsCommitting(globalId, ForceMode.unforced);
        log.force();
        log.close();
    }

    static class Verification
    implements AbstractSubProcessTestBase.Task {
        Verification() {
        }

        public void run(GraphDatabaseAPI graphdb) {
            Assert.assertNotNull((String)"No graph database", (Object)graphdb);
            Index index = graphdb.index().forNodes("nodes");
            Assert.assertNotNull((String)"No index", (Object)index);
            Node node = (Node)index.get("name", (Object)"value").getSingle();
            Assert.assertNotNull((String)"could not get the node", (Object)node);
            Assert.assertEquals((Object)"yes", (Object)node.getProperty("correct"));
        }
    }

    static class Crash
    implements AbstractSubProcessTestBase.Task {
        Crash() {
        }

        public void run(GraphDatabaseAPI graphdb) {
            throw new AssertionError((Object)"Should not reach here - the breakpoint should avoid it");
        }
    }

    static class Write1PCTransaction
    implements AbstractSubProcessTestBase.Task {
        Write1PCTransaction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(GraphDatabaseAPI graphdb) {
            Node node;
            Transaction tx = graphdb.beginTx();
            try {
                node = graphdb.createNode();
                tx.success();
            }
            finally {
                tx.finish();
            }
            tx = graphdb.beginTx();
            try {
                node.setProperty("correct", (Object)"yes");
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
    }

    static class WriteTransaction
    implements AbstractSubProcessTestBase.Task {
        WriteTransaction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(GraphDatabaseAPI graphdb) {
            Node node;
            Transaction tx = graphdb.beginTx();
            try {
                node = graphdb.createNode();
                tx.success();
            }
            finally {
                tx.finish();
            }
            tx = graphdb.beginTx();
            try {
                node.setProperty("correct", (Object)"yes");
                graphdb.index().forNodes("nodes").add((PropertyContainer)node, "name", (Object)"value");
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
    }
}

