/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.io.IOException;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TargetDirectory;

public class StartHaDb {
    public static final File BASE_PATH = TargetDirectory.forTest(StartHaDb.class).directory("dbs", false);

    public static void main(String[] args) throws Exception {
        GraphDatabaseService db = StartHaDb.startDb(new Args(args));
        System.out.println("Waiting for ENTER (for clean shutdown)");
        System.in.read();
        db.shutdown();
    }

    private static GraphDatabaseService startDb(Args args) throws IOException {
        if (!args.has("id")) {
            System.out.println("Supply 'id=<serverId>'");
            System.exit(1);
        }
        int serverId = args.getNumber("id", null).intValue();
        return new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(new File(BASE_PATH, "" + serverId).getAbsolutePath()).setConfig(ClusterSettings.initial_hosts, ":5001,:5002:5003").setConfig(HaSettings.server_id, "" + serverId).setConfig(HaSettings.ha_server, "127.0.0.1:" + (6001 + serverId)).setConfig(ShellSettings.remote_shell_enabled, "true").setConfig(ShellSettings.remote_shell_port, "" + (1337 + serverId)).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }
}

