/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.backup;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.backup.BackupExtensionService;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Predicates;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SystemOutLogging;

public final class HaBackupProvider
extends BackupExtensionService {
    public HaBackupProvider() {
        super("ha");
    }

    public URI resolve(URI address, Args args, Logging logging) {
        String master = null;
        StringLogger logger = logging.getLogger(HaBackupProvider.class);
        logger.debug("Asking cluster member at '" + address + "' for master");
        String clusterName = args.get(ClusterSettings.cluster_name.name(), null);
        if (clusterName == null) {
            clusterName = args.get(ClusterSettings.cluster_name.name(), ClusterSettings.cluster_name.getDefaultValue());
        }
        try {
            master = this.getMasterServerInCluster(address.getSchemeSpecificPart().substring(2), clusterName, logging);
            logger.debug("Found master '" + master + "' in cluster");
            return URI.create(master);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private String getMasterServerInCluster(String from, String clusterName, Logging logging) {
        LifeSupport life = new LifeSupport();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(HaSettings.server_id.name(), "-1");
        params.put(ClusterSettings.cluster_name.name(), clusterName);
        params.put(ClusterSettings.initial_hosts.name(), from);
        params.put(ClusterSettings.cluster_discovery_enabled.name(), "false");
        Config config = new Config(params, new Class[]{ClusterSettings.class, OnlineBackupSettings.class});
        final ClusterClient clusterClient = (ClusterClient)life.add((Object)new ClusterClient(ClusterClient.adapt((Config)config), logging, (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider()));
        ClusterMemberEvents events = (ClusterMemberEvents)life.add((Object)new PaxosClusterMemberEvents((Snapshot)clusterClient, (Cluster)clusterClient, (AtomicBroadcast)clusterClient, (Logging)new SystemOutLogging(), Predicates.TRUE()));
        clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                clusterClient.refreshSnapshot();
                clusterClient.removeClusterListener((ClusterListener)this);
            }
        });
        final Semaphore infoReceivedLatch = new Semaphore(0);
        final AtomicReference backupUri = new AtomicReference();
        events.addClusterMemberListener((ClusterMemberListener)new ClusterMemberListener.Adapter(){
            Map<URI, URI> backupUris = new HashMap<URI, URI>();
            URI master = null;

            public void memberIsAvailable(String role, URI clusterUri, URI roleUri) {
                if ("backup".equals(role)) {
                    this.backupUris.put(clusterUri, roleUri);
                } else if ("master".equals(role)) {
                    this.master = clusterUri;
                }
                if (this.master != null && this.backupUris.containsKey(this.master)) {
                    backupUri.set(this.backupUris.get(this.master));
                    infoReceivedLatch.release();
                }
            }
        });
        life.start();
        try {
            if (!infoReceivedLatch.tryAcquire(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Could not find backup server in cluster " + clusterName + " at " + from + ", " + "operation timed out");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            life.shutdown();
        }
        return ((URI)backupUri.get()).toString();
    }
}

