/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;

public enum HighAvailabilityMemberState {
    PENDING{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, URI masterURI) {
            assert (context.getAvailableHaMaster() == null);
            if (masterURI.equals(context.getMyId())) {
                return TO_MASTER;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, URI masterURI, URI masterHaURI) {
            if (masterURI.equals(context.getMyId())) {
                throw new RuntimeException("this cannot be happening");
            }
            return TO_SLAVE;
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, URI slaveUri) {
            if (slaveUri.equals(context.getMyId())) {
                throw new RuntimeException("cannot go from pending to slave");
            }
            return this;
        }

        @Override
        public boolean isAccessAllowed(HighAvailabilityMemberContext context) {
            return false;
        }
    }
    ,
    TO_SLAVE{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, URI masterURI) {
            if (masterURI.equals(context.getElectedMasterId())) {
                return this;
            }
            if (masterURI.equals(context.getMyId())) {
                return TO_MASTER;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, URI masterURI, URI masterHaURI) {
            if (masterURI.equals(context.getMyId())) {
                throw new RuntimeException("i (" + context.getMyId() + ") am trying to become a slave but " + "someone said i am available as master");
            }
            if (masterHaURI.equals(context.getAvailableHaMaster())) {
                return this;
            }
            throw new RuntimeException("my (" + context.getMyId() + ") current master is " + context.getAvailableHaMaster() + " (elected as " + context.getElectedMasterId() + " but i got a " + "masterIsAvailable event for " + masterHaURI);
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, URI slaveUri) {
            if (slaveUri.equals(context.getMyId())) {
                return SLAVE;
            }
            return this;
        }

        @Override
        public boolean isAccessAllowed(HighAvailabilityMemberContext context) {
            return false;
        }
    }
    ,
    TO_MASTER{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, URI masterURI) {
            assert (context.getAvailableHaMaster() == null);
            if (masterURI.equals(context.getMyId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, URI masterURI, URI masterHaURI) {
            if (masterURI.equals(context.getMyId())) {
                return MASTER;
            }
            throw new RuntimeException("i probably missed a masterIsElected event - not really that good");
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, URI slaveUri) {
            if (slaveUri.equals(context.getMyId())) {
                throw new RuntimeException("cannot be transitioning to master and slave at the same time");
            }
            return this;
        }

        @Override
        public boolean isAccessAllowed(HighAvailabilityMemberContext context) {
            return false;
        }
    }
    ,
    MASTER{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, URI masterURI) {
            if (masterURI.equals(context.getMyId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, URI masterURI, URI masterHaURI) {
            if (masterURI.equals(context.getMyId())) {
                return this;
            }
            throw new RuntimeException("I, " + context.getMyId() + " got a masterIsAvailable for " + masterHaURI + " (id is " + masterURI + " ) while being master. That should not happen");
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, URI slaveUri) {
            if (slaveUri.equals(context.getMyId())) {
                throw new RuntimeException("cannot be master and transition to slave at the same time");
            }
            return this;
        }

        @Override
        public boolean isAccessAllowed(HighAvailabilityMemberContext context) {
            return true;
        }
    }
    ,
    SLAVE{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, URI masterURI) {
            if (masterURI.equals(context.getMyId())) {
                return TO_MASTER;
            }
            if (masterURI.equals(context.getElectedMasterId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, URI masterURI, URI masterHaURI) {
            if (masterURI.equals(context.getMyId())) {
                throw new RuntimeException("master? i don't think so");
            }
            if (masterHaURI.equals(context.getAvailableHaMaster())) {
                return this;
            }
            throw new RuntimeException("i prolly missed a masterIsElected event, we're not looking good");
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, URI slaveUri) {
            return this;
        }

        @Override
        public boolean isAccessAllowed(HighAvailabilityMemberContext context) {
            return true;
        }
    };


    public abstract HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext var1, URI var2);

    public abstract HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext var1, URI var2, URI var3);

    public abstract HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext var1, URI var2);

    public abstract boolean isAccessAllowed(HighAvailabilityMemberContext var1);
}

