/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.management;

import java.net.URI;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.cluster.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.core.LastTxIdGetter;
import org.neo4j.management.ClusterDatabaseInfo;
import org.neo4j.management.ClusterMemberInfo;

public class ClusterDatabaseInfoProvider {
    private final ClusterMembers members;
    private final LastTxIdGetter txIdGetter;
    private final LastUpdateTime lastUpdateTime;

    public ClusterDatabaseInfoProvider(ClusterMembers members, LastTxIdGetter txIdGetter, LastUpdateTime lastUpdateTime) {
        this.members = members;
        this.txIdGetter = txIdGetter;
        this.lastUpdateTime = lastUpdateTime;
    }

    public ClusterDatabaseInfo getInfo() {
        ClusterMember self = this.members.getSelf();
        if (self == null) {
            return null;
        }
        URI haUri = self.getHAUri();
        int serverId = -1;
        if (haUri != null) {
            serverId = HighAvailabilityModeSwitcher.getServerId(haUri);
        }
        return new ClusterDatabaseInfo(new ClusterMemberInfo(self.getClusterUri().toString(), self.getHAUri() != null, true, self.getHARole(), (String[])Iterables.toArray(String.class, (Iterable)Iterables.map((Function)Functions.TO_STRING, self.getRoleURIs())), (String[])Iterables.toArray(String.class, (Iterable)Iterables.map((Function)Functions.TO_STRING, self.getRoles()))), this.txIdGetter.getLastTxId(), this.lastUpdateTime.getLastUpdateTime(), serverId);
    }
}

