/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestPullUpdates {
    private ClusterManager.ManagedCluster cluster;
    private static final int PULL_INTERVAL = 100;
    private static final int SHELL_PORT = 6370;

    @After
    public void doAfter() throws Throwable {
        if (this.cluster != null) {
            this.cluster.stop();
        }
    }

    @Test
    public void makeSureUpdatePullerGetsGoingAfterMasterSwitch() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).directory("makeSureUpdatePullerGetsGoingAfterMasterSwitch");
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(3), root, MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "100ms"}));
        clusterManager.start();
        this.cluster = clusterManager.getDefaultCluster();
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.setProperty(master, 1);
        this.awaitPropagation(1, this.cluster);
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        ClusterManager.RepairKit masterShutdownRK = this.cluster.shutdown(master);
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        this.setProperty(this.cluster.getMaster(), 2);
        masterShutdownRK.repair();
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        this.awaitPropagation(2, this.cluster);
    }

    @Test
    public void pullUpdatesShellAppPullsUpdates() throws Throwable {
        File root = TargetDirectory.forTest(this.getClass()).directory("pullUpdatesShellAppPullsUpdates");
        HashMap<Integer, Map<String, String>> instanceConfig = new HashMap<Integer, Map<String, String>>();
        for (int i = 1; i <= 2; ++i) {
            Map thisInstance = MapUtil.stringMap((String[])new String[]{ShellSettings.remote_shell_port.name(), "" + (6370 + i)});
            instanceConfig.put(i, thisInstance);
        }
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterOfSize(2), root, MapUtil.stringMap((String[])new String[]{HaSettings.pull_interval.name(), "0", HaSettings.tx_push_factor.name(), "0", ShellSettings.remote_shell_enabled.name(), "true"}), instanceConfig);
        clusterManager.start();
        this.cluster = clusterManager.getDefaultCluster();
        this.setProperty(this.cluster.getMaster(), 1);
        this.callPullUpdatesViaShell(2);
        Assert.assertEquals((Object)1, (Object)this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]).getReferenceNode().getProperty("i"));
    }

    private void callPullUpdatesViaShell(int i) throws ShellException {
        ShellClient client = ShellLobby.newClient((int)(6370 + i));
        client.evaluate("pullupdates");
    }

    private void powerNap() throws InterruptedException {
        Thread.sleep(50L);
    }

    private void awaitPropagation(int i, ClusterManager.ManagedCluster cluster) throws Exception {
        long endTime = System.currentTimeMillis() + 2000L;
        boolean ok = false;
        while (!ok && System.currentTimeMillis() < endTime) {
            ok = true;
            for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
                Object value = db.getReferenceNode().getProperty("i", null);
                if (value != null && (Integer)value == i) continue;
                ok = false;
            }
            if (ok) continue;
            this.powerNap();
        }
        Assert.assertTrue((String)"Change wasn't propagated by pulling updates", (boolean)ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(HighlyAvailableGraphDatabase db, int i) throws Exception {
        Transaction tx = db.beginTx();
        try {
            db.getReferenceNode().setProperty("i", (Object)i);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

