/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TxPushStrategyConfigIT {
    private LifeSupport life = new LifeSupport();
    private ClusterManager.ManagedCluster cluster;
    private TargetDirectory dir;
    @Rule
    public TestName name = new TestName();

    @Before
    public void before() throws Exception {
        this.dir = TargetDirectory.forTest(this.getClass());
    }

    @After
    public void after() throws Exception {
        this.life.shutdown();
    }

    private void startCluster(int memberCount, final int pushFactor, final String pushStrategy) {
        ClusterManager clusterManager = (ClusterManager)((Object)this.life.add((Object)new ClusterManager(ClusterManager.clusterOfSize(memberCount), this.dir.directory(this.name.getMethodName(), true), MapUtil.stringMap((String[])new String[0])){

            @Override
            protected void config(GraphDatabaseBuilder builder, String clusterName, int serverId) {
                builder.setConfig(HaSettings.tx_push_factor, "" + pushFactor);
                builder.setConfig(HaSettings.tx_push_strategy, pushStrategy);
            }
        }));
        this.life.start();
        this.cluster = clusterManager.getDefaultCluster();
    }

    @Test
    public void twoFixed() throws Exception {
        this.startCluster(4, 2, "fixed");
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(3));
        for (int i = 0; i < 5; ++i) {
            this.createTransactionOnMaster();
            this.assertLastTxId(2 + i, 4);
            this.assertLastTxId(2 + i, 3);
            this.assertLastTxId(1L, 2);
        }
    }

    @Test
    public void twoRoundRobin() throws Exception {
        this.startCluster(5, 2, "round_robin");
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(4));
        this.createTransactionOnMaster();
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(2L, 3);
        this.assertLastTxId(1L, 4);
        this.assertLastTxId(1L, 5);
        this.createTransactionOnMaster();
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(3L, 3);
        this.assertLastTxId(3L, 4);
        this.assertLastTxId(1L, 5);
        this.createTransactionOnMaster();
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(3L, 3);
        this.assertLastTxId(4L, 4);
        this.assertLastTxId(4L, 5);
        this.createTransactionOnMaster();
        this.assertLastTxId(5L, 2);
        this.assertLastTxId(3L, 3);
        this.assertLastTxId(4L, 4);
        this.assertLastTxId(5L, 5);
    }

    @Test
    public void twoFixedFromSlaveCommit() throws Exception {
        this.startCluster(4, 2, "fixed");
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(3));
        this.createTransactionOn(2);
        this.assertLastTxId(2L, 4);
        this.assertLastTxId(1L, 3);
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(2L, 1);
        this.createTransactionOn(3);
        this.assertLastTxId(3L, 4);
        this.assertLastTxId(3L, 3);
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(3L, 1);
        this.createTransactionOn(4);
        this.assertLastTxId(4L, 4);
        this.assertLastTxId(4L, 3);
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(4L, 1);
    }

    @Test
    public void slavesListGetsUpdatedWhenSlaveLeavesNicely() throws Exception {
        this.startCluster(3, 1, "fixed");
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        this.cluster.shutdown(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
    }

    @Test
    public void slaveListIsCorrectAfterMasterSwitch() throws Exception {
        this.startCluster(3, 1, "fixed");
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
        this.cluster.shutdown(this.cluster.getMaster());
        this.cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]), 10);
        HighlyAvailableGraphDatabase newMaster = this.cluster.getMaster();
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        this.createTransaction((GraphDatabaseAPI)newMaster);
        this.assertLastTxId(2L, 2);
        this.assertLastTxId(2L, 3);
    }

    @Test
    public void slavesListGetsUpdatedWhenSlaveRageQuits() throws Throwable {
        this.startCluster(3, 1, "fixed");
        this.cluster.fail(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]));
        this.cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
    }

    private void assertLastTxId(long tx, int serverId) {
        HighlyAvailableGraphDatabase db = this.cluster.getMemberByServerId(serverId);
        Assert.assertEquals((long)tx, (long)db.getXaDataSourceManager().getNeoStoreDataSource().getLastCommittedTxId());
    }

    private void createTransactionOnMaster() {
        this.createTransaction((GraphDatabaseAPI)this.cluster.getMaster());
    }

    private void createTransactionOn(int serverId) {
        this.createTransaction((GraphDatabaseAPI)this.cluster.getMemberByServerId(serverId));
    }

    private void createTransaction(GraphDatabaseAPI db) {
        Transaction tx = db.beginTx();
        try {
            db.createNode();
            tx.success();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            tx.finish();
        }
    }
}

