/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

public class ForeignStoreIdIT {
    private final TargetDirectory DIR = TargetDirectory.forTest(this.getClass());
    private GraphDatabaseService firstInstance;
    private GraphDatabaseService foreignInstance;

    @Test
    public void emptyForeignDbShouldJoinAfterHavingItsEmptyDbDeleted() throws Exception {
        this.firstInstance = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.DIR.directory("1", true).getAbsolutePath()).setConfig(HaSettings.server_id, "1").setConfig(ClusterSettings.cluster_server, ":5001").setConfig(HaSettings.ha_server, ":6001").newGraphDatabase();
        String foreignDbStoreDir = this.createAnotherStore(this.DIR.directory("2", true), 0);
        this.foreignInstance = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(foreignDbStoreDir).setConfig(HaSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, ":5001").setConfig(ClusterSettings.cluster_server, ":5002").setConfig(HaSettings.ha_server, ":6002").newGraphDatabase();
        long foreignNode = this.createNode(this.foreignInstance, "foreigner");
        Assert.assertEquals((long)foreignNode, (long)this.findNode(this.firstInstance, "foreigner"));
    }

    @Test
    public void nonEmptyForeignDbShouldNotBeAbleToJoin() throws Exception {
        this.firstInstance = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.DIR.directory("1", true).getAbsolutePath()).setConfig(HaSettings.server_id, "1").setConfig(ClusterSettings.cluster_server, ":5001").setConfig(HaSettings.ha_server, ":6001").newGraphDatabase();
        this.createNodes(this.firstInstance, 3, "first");
        String foreignDbStoreDir = this.createAnotherStore(this.DIR.directory("2", true), 1);
        this.foreignInstance = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(foreignDbStoreDir).setConfig(HaSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, ":5001").setConfig(ClusterSettings.cluster_server, ":5002").setConfig(HaSettings.ha_server, ":6002").setConfig(HaSettings.state_switch_timeout, "5s").newGraphDatabase();
        try {
            this.createNode(this.foreignInstance, "foreigner");
            Assert.fail((String)"Shouldn't be able to create a node, since it shouldn't have joined");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @After
    public void after() throws Exception {
        if (this.foreignInstance != null) {
            this.foreignInstance.shutdown();
        }
        if (this.firstInstance != null) {
            this.firstInstance.shutdown();
        }
    }

    private long findNode(GraphDatabaseService db, String name) {
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
            if (!name.equals(node.getProperty("name", null))) continue;
            return node.getId();
        }
        Assert.fail((String)("Didn't find node '" + name + "' in " + db));
        return -1L;
    }

    private String createAnotherStore(File directory, int transactions) {
        String storeDir = directory.getAbsolutePath();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir);
        this.createNodes((GraphDatabaseService)db, transactions, "node");
        db.shutdown();
        return storeDir;
    }

    private void createNodes(GraphDatabaseService db, int transactions, String prefix) {
        for (int i = 0; i < transactions; ++i) {
            this.createNode(db, prefix + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createNode(GraphDatabaseService db, String name) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
        finally {
            tx.finish();
        }
    }
}

