/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class TestClusterClientPadding {
    private static TargetDirectory dir = TargetDirectory.forTest(TestClusterClientPadding.class);
    private LifeSupport life = new LifeSupport();
    private ClusterManager clusterManager;
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void before() throws Throwable {
        this.clusterManager = (ClusterManager)((Object)this.life.add((Object)new ClusterManager(ClusterManager.clusterWithAdditionalClients(2, 1), dir.directory("dbs", true), MapUtil.stringMap((String[])new String[0]))));
        this.life.start();
        this.cluster = this.clusterManager.getDefaultCluster();
        this.cluster.await(ClusterManager.masterSeesMembers(3));
    }

    @After
    public void after() throws Throwable {
        this.life.stop();
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterIsShutDown() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.shutdown(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable(sittingMaster));
    }

    @Test
    public void additionalClusterClientCanHelpBreakTiesWhenMasterFails() throws Throwable {
        HighlyAvailableGraphDatabase sittingMaster = this.cluster.getMaster();
        this.cluster.fail(sittingMaster);
        this.cluster.await(ClusterManager.masterAvailable(sittingMaster));
    }
}

