/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.test.StreamConsumer;
import org.neo4j.test.TargetDirectory;

public class TestPullUpdatesApplied {
    private final HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[3];
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public void doBefore() throws Exception {
        for (int i = 0; i < this.dbs.length; ++i) {
            this.dbs[i] = this.newDb(i);
            Thread.sleep(1000L);
        }
    }

    private HighlyAvailableGraphDatabase newDb(int i) {
        return this.newDb(i, true);
    }

    private HighlyAvailableGraphDatabase newDb(int i, boolean clear) {
        return (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.dir.directory("" + i, clear).getAbsolutePath()).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + i)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(HaSettings.server_id, "" + i).setConfig(HaSettings.ha_server, "localhost:" + (6666 + i)).setConfig(HaSettings.pull_interval, "0ms").newGraphDatabase();
    }

    @After
    public void doAfter() throws Exception {
        for (HighlyAvailableGraphDatabase db : this.dbs) {
            if (db == null) continue;
            db.shutdown();
        }
    }

    @Test
    public void testUpdatesAreWrittenToLogBeforeBeingAppliedToStore() throws Exception {
        int master = this.getCurrentMaster();
        this.addNode(master);
        int toKill = (master + 1) % this.dbs.length;
        HighlyAvailableGraphDatabase dbToKill = this.dbs[toKill];
        final CountDownLatch latch1 = new CountDownLatch(1);
        final HighlyAvailableGraphDatabase masterDb = this.dbs[master];
        ((ClusterClient)masterDb.getDependencyResolver().resolveDependency(ClusterClient.class)).addClusterListener((ClusterListener)new ClusterListener.Adapter(){

            public void leftCluster(URI member) {
                latch1.countDown();
                ((ClusterClient)masterDb.getDependencyResolver().resolveDependency(ClusterClient.class)).removeClusterListener((ClusterListener)this);
            }
        });
        dbToKill.shutdown();
        latch1.await();
        this.addNode(master);
        File targetDirectory = this.dir.directory("" + toKill, false);
        dbToKill.shutdown();
        final CountDownLatch latch2 = new CountDownLatch(1);
        ((ClusterClient)masterDb.getDependencyResolver().resolveDependency(ClusterClient.class)).addHeartbeatListener((HeartbeatListener)new HeartbeatListener.Adapter(){

            public void failed(URI server) {
                latch2.countDown();
                ((ClusterClient)masterDb.getDependencyResolver().resolveDependency(ClusterClient.class)).removeHeartbeatListener((HeartbeatListener)this);
            }
        });
        TestPullUpdatesApplied.runInOtherJvmToGetExitCode(targetDirectory.getAbsolutePath(), "" + toKill);
        latch2.await();
        this.start(toKill, false);
        boolean hasBranchedData = new File(targetDirectory, "branched").listFiles().length > 0;
        Assert.assertFalse((boolean)hasBranchedData);
    }

    public static void main(String[] args) throws Exception {
        int i = Integer.parseInt(args[1]);
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(args[0]).setConfig(HaSettings.server_id, "" + i).setConfig(HaSettings.ha_server, "localhost:" + (6666 + i)).setConfig(HaSettings.pull_interval, "0ms").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + i) + "").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").newGraphDatabase();
        ((UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
    }

    public static int runInOtherJvmToGetExitCode(String ... args) throws Exception {
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList("java", "-cp", System.getProperty("java.class.path"), TestPullUpdatesApplied.class.getName()));
        allArgs.addAll(Arrays.asList(args));
        Process p = Runtime.getRuntime().exec(allArgs.toArray(new String[allArgs.size()]));
        LinkedList<Thread> threads = new LinkedList<Thread>();
        TestPullUpdatesApplied.launchStreamConsumers(threads, p);
        Thread.sleep(5000L);
        p.destroy();
        for (Thread t : threads) {
            t.join();
        }
        return 0;
    }

    private static void launchStreamConsumers(List<Thread> join, Process p) {
        InputStream outStr = p.getInputStream();
        InputStream errStr = p.getErrorStream();
        Thread out = new Thread((Runnable)new StreamConsumer(outStr, (OutputStream)System.out, false));
        join.add(out);
        Thread err = new Thread((Runnable)new StreamConsumer(errStr, (OutputStream)System.err, false));
        join.add(err);
        out.start();
        err.start();
    }

    private void start(int master, boolean clear) {
        this.dbs[master] = this.newDb(master, clear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addNode(int dbId) {
        HighlyAvailableGraphDatabase db = this.dbs[dbId];
        long result = -1L;
        Transaction tx = db.beginTx();
        try {
            result = db.createNode().getId();
            tx.success();
        }
        finally {
            tx.finish();
        }
        return result;
    }

    private int getCurrentMaster() throws Exception {
        for (int i = 0; i < this.dbs.length; ++i) {
            HighlyAvailableGraphDatabase db = this.dbs[i];
            if (!db.isMaster()) continue;
            return i;
        }
        return -1;
    }
}

