/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.ha.BeginTx;
import org.neo4j.ha.FinishTx;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.OtherThreadExecutor;

public class TransactionConstraintsIT
extends AbstractClusterTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void start_tx_as_slave_and_finish_it_after_having_switched_to_master_should_not_succeed() throws Exception {
        HighlyAvailableGraphDatabase db = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.takeTheLeadInAnEventualMasterSwitch((GraphDatabaseService)db);
        Transaction tx = db.beginTx();
        try {
            db.getReferenceNode().setProperty("name", (Object)"slave");
            tx.success();
        }
        finally {
            this.cluster.shutdown(this.cluster.getMaster());
            this.assertFinishGetsTransactionFailure(tx);
        }
        Assert.assertEquals((Object)db, (Object)this.cluster.getMaster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void start_tx_as_slave_and_finish_it_after_another_master_being_available_should_not_succeed() throws Exception {
        HighlyAvailableGraphDatabase db = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Transaction tx = db.beginTx();
        try {
            db.getReferenceNode().setProperty("name", (Object)"slave");
            tx.success();
        }
        catch (Throwable throwable) {
            HighlyAvailableGraphDatabase theOtherSlave = this.cluster.getAnySlave(db);
            this.takeTheLeadInAnEventualMasterSwitch((GraphDatabaseService)theOtherSlave);
            this.cluster.shutdown(this.cluster.getMaster());
            this.assertFinishGetsTransactionFailure(tx);
            throw throwable;
        }
        HighlyAvailableGraphDatabase theOtherSlave = this.cluster.getAnySlave(db);
        this.takeTheLeadInAnEventualMasterSwitch((GraphDatabaseService)theOtherSlave);
        this.cluster.shutdown(this.cluster.getMaster());
        this.assertFinishGetsTransactionFailure(tx);
        Assert.assertFalse((boolean)db.isMaster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void slave_should_not_be_able_to_produce_an_invalid_transaction() throws Exception {
        HighlyAvailableGraphDatabase aSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Node node = this.createMiniTree((GraphDatabaseService)aSlave);
        Transaction tx = aSlave.beginTx();
        try {
            node.delete();
            tx.success();
        }
        finally {
            this.assertFinishGetsTransactionFailure(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void master_should_not_be_able_to_produce_an_invalid_transaction() throws Exception {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        Node node = this.createMiniTree((GraphDatabaseService)master);
        Transaction tx = master.beginTx();
        try {
            node.delete();
            tx.success();
        }
        finally {
            this.assertFinishGetsTransactionFailure(tx);
        }
    }

    @Test
    public void write_operation_on_slave_has_to_be_performed_within_a_transaction() throws Exception {
        HighlyAvailableGraphDatabase aSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try {
            aSlave.createNode();
            Assert.fail((String)"Shouldn't be able to do a write operation outside a transaction");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
    }

    @Test
    public void write_operation_on_master_has_to_be_performed_within_a_transaction() throws Exception {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        try {
            master.createNode();
            Assert.fail((String)"Shouldn't be able to do a write operation outside a transaction");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void slave_should_not_be_able_to_modify_node_deleted_on_master() throws Exception {
        HighlyAvailableGraphDatabase aSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Node node = this.createNode((GraphDatabaseService)aSlave);
        this.deleteNode(this.cluster.getMaster(), node.getId());
        Transaction tx = aSlave.beginTx();
        try {
            node.setProperty("name", (Object)"test");
            Assert.fail((String)"Shouldn't be able to modify a node deleted on master");
        }
        catch (NotFoundException e) {
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void deadlock_detection_involving_two_slaves() throws Exception {
        HighlyAvailableGraphDatabase slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.deadlockDetectionBetween(slave1, this.cluster.getAnySlave(slave1));
    }

    @Test
    public void deadlock_detection_involving_slave_and_master() throws Exception {
        this.deadlockDetectionBetween(this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]), this.cluster.getMaster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deadlockDetectionBetween(HighlyAvailableGraphDatabase slave1, HighlyAvailableGraphDatabase slave2) throws Exception {
        OtherThreadExecutor thread2 = new OtherThreadExecutor("T2", (Object)slave2);
        Transaction tx1 = slave1.beginTx();
        Transaction tx2 = (Transaction)thread2.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
        tx1.acquireReadLock((PropertyContainer)slave1.getReferenceNode());
        thread2.execute((OtherThreadExecutor.WorkerCommand)new AcquireReadLock(tx2, slave2.getReferenceNode()));
        Future writeLockFuture = thread2.executeDontWait((OtherThreadExecutor.WorkerCommand)new AcquireWriteLock(tx2, slave2.getReferenceNode()));
        thread2.waitUntilThreadState(new Thread.State[]{Thread.State.TIMED_WAITING, Thread.State.WAITING});
        try {
            tx1.acquireWriteLock((PropertyContainer)slave1.getReferenceNode());
            Assert.fail((String)"Deadlock exception should have been thrown");
        }
        catch (DeadlockDetectedException e) {
        }
        finally {
            tx1.finish();
        }
        Assert.assertNotNull(writeLockFuture.get());
        thread2.execute((OtherThreadExecutor.WorkerCommand)new FinishTx(tx2, true));
        thread2.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Known issue where locks acquired from Transaction#acquireXXXLock() methods doesn't get properly released when calling Lock#release() method")
    @Test
    public void manually_acquire_and_release_transaction_lock() throws Exception {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        OtherThreadExecutor masterWorker = new OtherThreadExecutor("master worker", (Object)master);
        Node node = this.createNode((GraphDatabaseService)master);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Transaction slaveTx = slave.beginTx();
        try {
            Lock lock = slaveTx.acquireWriteLock((PropertyContainer)slave.getNodeById(node.getId()));
            lock.release();
            Transaction masterTx = (Transaction)masterWorker.execute((OtherThreadExecutor.WorkerCommand)new BeginTx());
            masterWorker.execute((OtherThreadExecutor.WorkerCommand)new AcquireWriteLock(masterTx, node), 1L, TimeUnit.SECONDS);
        }
        finally {
            slaveTx.finish();
            masterWorker.shutdown();
        }
    }

    private void takeTheLeadInAnEventualMasterSwitch(GraphDatabaseService db) {
        this.createNode(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNode(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            node.setProperty("name", (Object)"yo");
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createMiniTree(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        try {
            Node root = db.createNode();
            root.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            root.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
            Node node = root;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNode(HighlyAvailableGraphDatabase db, long id) {
        Transaction tx = db.beginTx();
        try {
            db.getNodeById(id).delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    protected void configureClusterMember(GraphDatabaseBuilder builder, String clusterName, int serverId) {
        super.configureClusterMember(builder, clusterName, serverId);
        builder.setConfig(HaSettings.tx_push_factor, "0");
        builder.setConfig(HaSettings.pull_interval, "0");
    }

    private void assertFinishGetsTransactionFailure(Transaction tx) {
        try {
            tx.finish();
            Assert.fail((String)"Transaction shouldn't be able to finish");
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
    }

    private static class AcquireWriteLock
    implements OtherThreadExecutor.WorkerCommand<HighlyAvailableGraphDatabase, Lock> {
        private final Transaction tx;
        private final Node node;

        public AcquireWriteLock(Transaction tx, Node node) {
            this.tx = tx;
            this.node = node;
        }

        public Lock doWork(HighlyAvailableGraphDatabase state) {
            return this.tx.acquireWriteLock((PropertyContainer)this.node);
        }
    }

    private static class AcquireReadLock
    implements OtherThreadExecutor.WorkerCommand<HighlyAvailableGraphDatabase, Lock> {
        private final Transaction tx;
        private final Node node;

        public AcquireReadLock(Transaction tx, Node node) {
            this.tx = tx;
            this.node = node;
        }

        public Lock doWork(HighlyAvailableGraphDatabase state) {
            return this.tx.acquireReadLock((PropertyContainer)this.node);
        }
    }
}

