/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;

@Ignore(value="This test currently fails by never finishing.")
public class ConcurrentInstanceStartupIT {
    public static TargetDirectory testDirectory = TargetDirectory.forTest(ConcurrentInstanceStartupIT.class);

    @Test
    public void concurrentStartupShouldWork() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(3);
        ArrayList<Thread> daThreads = new ArrayList<Thread>(3);
        final HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[3];
        int i = 1;
        while (i <= 3) {
            final int finalI = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        barrier.await();
                        dbs[finalI - 1] = ConcurrentInstanceStartupIT.this.startDbAtBase(finalI);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (BrokenBarrierException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            daThreads.add(t);
            t.start();
        }
        for (Thread daThread : daThreads) {
            daThread.join();
        }
        for (HighlyAvailableGraphDatabase db : dbs) {
            Transaction tx = db.beginTx();
            db.createNode();
            tx.success();
            tx.finish();
        }
        for (HighlyAvailableGraphDatabase db : dbs) {
            db.shutdown();
        }
    }

    private HighlyAvailableGraphDatabase startDbAtBase(int i) {
        GraphDatabaseBuilder masterBuilder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.path(i).getAbsolutePath()).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001,127.0.0.1:5002,127.0.0.1:5003").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5000 + i)).setConfig(HaSettings.server_id, "" + i).setConfig(HaSettings.ha_server, ":" + (8000 + i)).setConfig(HaSettings.tx_push_factor, "0");
        return (HighlyAvailableGraphDatabase)masterBuilder.newGraphDatabase();
    }

    private File path(int i) {
        return testDirectory.directory(i + "", true);
    }
}

