/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.ha.EnterpriseConfigurationMigrator;
import org.neo4j.kernel.impl.util.StringLogger;

public class EnterpriseConfigurationMigratorTest {
    ConfigurationMigrator migrator = new EnterpriseConfigurationMigrator();

    @Test
    public void testOnlineBackupMigration() throws Exception {
        Map original = MapUtil.stringMap((String[])new String[]{"enable_online_backup", "true"});
        Map migrated = this.migrator.apply(original, StringLogger.SYSTEM);
        Assert.assertThat((Object)migrated.containsKey("enable_online_backup"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(migrated.get("online_backup_enabled"), (Matcher)CoreMatchers.is((Object)"true"));
        Assert.assertThat(migrated.get("online_backup_server"), (Matcher)CoreMatchers.is((Object)OnlineBackupSettings.online_backup_server.getDefaultValue()));
    }

    @Test
    public void testOnlineBackupPortMigration() throws Exception {
        Map original = MapUtil.stringMap((String[])new String[]{"enable_online_backup", "port=123"});
        Map migrated = this.migrator.apply(original, StringLogger.SYSTEM);
        Assert.assertThat((Object)migrated.containsKey("enable_online_backup"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(migrated.get("online_backup_enabled"), (Matcher)CoreMatchers.is((Object)"true"));
        Assert.assertThat(migrated.get("online_backup_server"), (Matcher)CoreMatchers.is((Object)":123"));
    }

    @Test
    public void testMachineIdMigration() throws Exception {
        Map original = MapUtil.stringMap((String[])new String[]{"ha.machine_id", "123"});
        Map migrated = this.migrator.apply(original, StringLogger.SYSTEM);
        Assert.assertThat((Object)migrated.containsKey("ha.machine_id"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(migrated.get("ha.server_id"), (Matcher)CoreMatchers.is((Object)"123"));
    }
}

