/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.consistency.ConsistencyCheckTool;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.test.TargetDirectory;

public class RobustnessIT {
    private final File path = TargetDirectory.forTest(this.getClass()).graphDbDir(true);
    private HighlyAvailableGraphDatabase[] dbs;

    @Test
    public void bringUpClusterAndIssueSomeWriteCommandsOnEachMember() throws Exception {
        HighlyAvailableGraphDatabase db2;
        HighlyAvailableGraphDatabase db1;
        int i;
        this.dbs = new HighlyAvailableGraphDatabase[3];
        this.dbs[0] = this.startDb(0);
        List<Node> nodes = Collections.synchronizedList(new LinkedList());
        List<Relationship> rels = Collections.synchronizedList(new LinkedList());
        for (i = 0; i < 10; ++i) {
            this.createInitial(this.dbs[0], nodes, rels);
        }
        this.dbs[1] = this.startDb(1);
        this.assertExists(this.dbs[1], nodes, rels);
        this.dbs[2] = this.startDb(2);
        this.assertExists(this.dbs[2], nodes, rels);
        this.debug("============== Case simple master switch test ================");
        this.debug("Start master test");
        this.dbs[0].shutdown();
        this.debug("0 is now dead");
        Thread.sleep(3000L);
        Assert.assertTrue((this.dbs[1].isMaster() || this.dbs[2].isMaster() ? 1 : 0) != 0);
        this.dbs[0] = this.startDb(0);
        this.debug("0 is now back on");
        Assert.assertTrue((boolean)this.dbs[1].isMaster());
        Assert.assertFalse((boolean)this.dbs[0].isMaster());
        this.debug("============== Case brutal master switch test with create ================");
        for (i = 0; i < 6; ++i) {
            int k;
            int j = this.findMaster();
            db1 = this.dbs[(j + 1) % this.dbs.length];
            db2 = this.dbs[(j + 2) % this.dbs.length];
            ((UpdatePuller)db1.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            ((UpdatePuller)db2.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            this.debug("Starting kill of " + j);
            this.dbs[j].shutdown();
            this.debug("========> killed " + j);
            for (k = 0; k < 10; ++k) {
                this.createNodeAndRelationship(db1, nodes, rels);
                this.createNodeAndRelationship(db2, nodes, rels);
            }
            Thread.sleep(3000L);
            this.debug("Starting " + this.dbs[j]);
            this.dbs[j] = this.startDb(j);
            this.debug("Done starting " + j);
            Thread.sleep(3000L);
            for (k = 0; k < 10; ++k) {
                this.debug("Creating on " + (j + 1) % this.dbs.length);
                this.createNodeAndRelationship(db1, nodes, rels);
                this.debug("Creating on " + (j + 2) % this.dbs.length);
                this.createNodeAndRelationship(db2, nodes, rels);
                this.debug("Creating on " + (j + 3) % this.dbs.length);
                this.createNodeAndRelationship(this.dbs[(j + 3) % this.dbs.length], nodes, rels);
            }
        }
        int currentMaster = this.findMaster();
        HighlyAvailableGraphDatabase master = this.dbs[currentMaster];
        this.assertExists(master, nodes, rels);
        db1 = this.dbs[(currentMaster + 1) % this.dbs.length];
        ((UpdatePuller)db1.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        this.assertExists(db1, nodes, rels);
        db2 = this.dbs[(currentMaster + 2) % this.dbs.length];
        ((UpdatePuller)db2.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        this.assertExists(db2, nodes, rels);
        for (HighlyAvailableGraphDatabase db : this.dbs) {
            db.shutdown();
            Thread.sleep(1000L);
            ConsistencyCheckTool.main((String[])new String[]{db.getStoreDir(), "-recovery"});
        }
        this.dbs = this.startCluster(3);
        this.debug("============== Case switch master, create on slave simple ================");
        this.dbs[0].shutdown();
        for (int i2 = 0; i2 < 1; ++i2) {
            for (int db = 1; db < this.dbs.length; ++db) {
                this.createNodeAndRelationship(this.dbs[db], nodes, rels);
            }
        }
        ((UpdatePuller)this.dbs[2].getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        this.assertExists(this.dbs[1], nodes, rels);
        this.assertExists(this.dbs[2], nodes, rels);
        this.debug("============== Case remove master, slave alone still works ================");
        this.dbs[1].shutdown();
        this.createNodeAndRelationship(this.dbs[2], nodes, rels);
        this.assertExists(this.dbs[2], nodes, rels);
        this.debug("============== Case instance joins single machine cluster ================");
        this.dbs[1] = this.startDb(1);
        this.createNodeAndRelationship(this.dbs[1], nodes, rels);
        this.assertExists(this.dbs[1], nodes, rels);
        this.assertExists(this.dbs[2], nodes, rels);
        this.debug("============== Case remove slave, master still working ================");
        this.dbs[1].shutdown();
        while (true) {
            try {
                this.createNodeAndRelationship(this.dbs[2], nodes, rels);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        this.assertExists(this.dbs[2], nodes, rels);
        this.debug("============== Done ================");
        this.dbs[2].shutdown();
        for (HighlyAvailableGraphDatabase db : this.dbs) {
            Thread.sleep(3000L);
            this.debug("Checking " + db);
        }
    }

    private void debug(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInitial(HighlyAvailableGraphDatabase db, List<Node> nodes, List<Relationship> relationships) {
        while (true) {
            Transaction tx = db.beginTx();
            try {
                Node node = db.createNode();
                nodes.add(node);
                Relationship rel = db.getReferenceNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
                relationships.add(rel);
                tx.success();
                return;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                e.printStackTrace();
                continue;
            }
            finally {
                try {
                    tx.finish();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    private int findMaster() {
        for (int i = 0; i < this.dbs.length; ++i) {
            if (!this.dbs[i].isMaster()) continue;
            this.debug("Found master as " + i);
            return i;
        }
        return -1;
    }

    private void assertExists(HighlyAvailableGraphDatabase db, List<Node> nodes, List<Relationship> rels) {
        for (Node n : nodes) {
            db.getNodeById(n.getId());
        }
        for (Relationship rel : rels) {
            Relationship thisRel = db.getRelationshipById(rel.getId());
            Assert.assertEquals((Object)db.getRelationshipById(rel.getId()).getStartNode(), (Object)db.getRelationshipById(thisRel.getId()).getStartNode());
            Assert.assertEquals((Object)db.getRelationshipById(rel.getId()).getEndNode(), (Object)db.getRelationshipById(thisRel.getId()).getEndNode());
        }
        int nodeCount = 0;
        int relCount = 0;
        for (Node n : db.getAllNodes()) {
            ++nodeCount;
            for (Relationship rel : n.getRelationships(Direction.OUTGOING)) {
                ++relCount;
            }
        }
        Assert.assertEquals((long)(nodes.size() + 1), (long)nodeCount);
        Assert.assertEquals((long)rels.size(), (long)relCount);
    }

    private Relationship findRelationship(Node referenceNode, Relationship other) {
        for (Relationship rel : referenceNode.getRelationships()) {
            if (!rel.equals(other)) continue;
            return rel;
        }
        Assert.fail((String)(other + " not found in " + referenceNode.getGraphDatabase()));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNodeAndRelationship(HighlyAvailableGraphDatabase db, List<Node> nodes, List<Relationship> rels) {
        while (true) {
            Transaction tx = db.beginTx();
            try {
                Node node = db.createNode();
                nodes.add(node);
                Node from = db.getNodeById(nodes.get(nodes.size() - 1).getId());
                Relationship rel = from.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
                rels.add(rel);
                Relationship rad = db.getReferenceNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
                rels.add(rad);
                tx.success();
                return;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                e.printStackTrace();
                continue;
            }
            finally {
                try {
                    tx.finish();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    private HighlyAvailableGraphDatabase[] startCluster(int size) {
        HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[size];
        for (int serverId = 0; serverId < size; ++serverId) {
            dbs[serverId] = this.startDb(serverId);
        }
        return dbs;
    }

    private HighlyAvailableGraphDatabase startDb(int serverId) {
        GraphDatabaseBuilder builder = new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.path(serverId)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001,127.0.0.1:5002,127.0.0.1:5003").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + serverId)).setConfig(HaSettings.server_id, "" + serverId).setConfig(HaSettings.ha_server, ":" + (8001 + serverId)).setConfig(HaSettings.tx_push_factor, "0").setConfig((Setting)GraphDatabaseSettings.intercept_committing_transactions, "true").setConfig((Setting)GraphDatabaseSettings.intercept_deserialized_transactions, "true").setConfig(TransactionInterceptorProvider.class.getSimpleName() + "." + "verifying", "true");
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)builder.newGraphDatabase();
        Transaction tx = db.beginTx();
        tx.finish();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return db;
    }

    private String path(int i) {
        return new File(this.path, "" + i).getAbsolutePath();
    }
}

