/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.com.ComException;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionStream;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlavePriorities;
import org.neo4j.kernel.ha.com.master.SlavePriority;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.transaction.MasterTxIdGenerator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.TargetDirectory;

public class TestMasterCommittingAtSlave {
    private Iterable<Slave> slaves;
    private XaDataSource dataSource;
    private FakeStringLogger log;
    private static final FileSystemAbstraction FS = new DefaultFileSystemAbstraction();

    @Test
    public void commitSuccessfullyToTheFirstOne() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 1, SlavePriorities.givenOrder(), new boolean[0]);
        generator.committed(this.dataSource, 0, 2L, null);
        this.assertCalls((FakeSlave)this.slaves.iterator().next(), 2L);
        this.assertNoFailureLogs();
    }

    @Test
    public void commitACoupleOfTransactionsSuccessfully() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 1, SlavePriorities.givenOrder(), new boolean[0]);
        generator.committed(this.dataSource, 0, 2L, null);
        generator.committed(this.dataSource, 0, 3L, null);
        generator.committed(this.dataSource, 0, 4L, null);
        this.assertCalls((FakeSlave)this.slaves.iterator().next(), 2L, 3L, 4L);
        this.assertNoFailureLogs();
    }

    @Test
    public void commitFailureAtFirstOneShouldMoveOnToNext() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 1, SlavePriorities.givenOrder(), true);
        generator.committed(this.dataSource, 0, 2L, null);
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), new long[0]);
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        this.assertNoFailureLogs();
    }

    @Test
    public void commitSuccessfullyAtThreeSlaves() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(5, 3, SlavePriorities.givenOrder(), new boolean[0]);
        generator.committed(this.dataSource, 0, 2L, null);
        generator.committed(this.dataSource, 0, 3L, Integer.valueOf(1));
        generator.committed(this.dataSource, 0, 4L, Integer.valueOf(3));
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 3L, 4L);
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 4L);
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 3L);
        this.assertCalls((FakeSlave)slaveIt.next(), new long[0]);
        this.assertCalls((FakeSlave)slaveIt.next(), new long[0]);
        this.assertNoFailureLogs();
    }

    @Test
    public void commitSuccessfullyOnSomeOfThreeSlaves() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(5, 3, SlavePriorities.givenOrder(), false, true, true);
        generator.committed(this.dataSource, 0, 2L, null);
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        slaveIt.next();
        slaveIt.next();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        this.assertNoFailureLogs();
    }

    @Test
    public void roundRobinSingleSlave() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 1, SlavePriorities.roundRobin(), new boolean[0]);
        for (long tx = 2L; tx <= 6L; ++tx) {
            generator.committed(this.dataSource, 0, tx, null);
        }
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 5L);
        this.assertCalls((FakeSlave)slaveIt.next(), 3L, 6L);
        this.assertCalls((FakeSlave)slaveIt.next(), 4L);
        this.assertNoFailureLogs();
    }

    @Test
    public void roundRobinSomeFailing() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(4, 2, SlavePriorities.roundRobin(), false, true);
        for (long tx = 2L; tx <= 6L; ++tx) {
            generator.committed(this.dataSource, 0, tx, null);
        }
        Iterator<Slave> slaveIt = this.slaves.iterator();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 5L, 6L);
        slaveIt.next();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L, 3L, 4L, 6L);
        this.assertCalls((FakeSlave)slaveIt.next(), 3L, 4L, 5L);
        this.assertNoFailureLogs();
    }

    @Test
    public void notEnoughSlavesSuccessful() throws Exception {
        MasterTxIdGenerator generator = this.newGenerator(3, 2, SlavePriorities.givenOrder(), true, true);
        generator.committed(this.dataSource, 0, 2L, null);
        Iterator<Slave> slaveIt = this.slaves.iterator();
        slaveIt.next();
        slaveIt.next();
        this.assertCalls((FakeSlave)slaveIt.next(), 2L);
        this.assertFailureLogs();
    }

    @Test
    public void testFixedPriorityStrategy() {
        int[] serverIds = new int[]{55, 101, 66};
        SlavePriority fixed = SlavePriorities.fixed();
        ArrayList<FakeSlave> slaves = new ArrayList<FakeSlave>(3);
        slaves.add(new FakeSlave(false, serverIds[0]));
        slaves.add(new FakeSlave(false, serverIds[1]));
        slaves.add(new FakeSlave(false, serverIds[2]));
        Iterator sortedSlaves = fixed.prioritize(slaves).iterator();
        Assert.assertEquals((long)serverIds[1], (long)((Slave)sortedSlaves.next()).getServerId());
        Assert.assertEquals((long)serverIds[2], (long)((Slave)sortedSlaves.next()).getServerId());
        Assert.assertEquals((long)serverIds[0], (long)((Slave)sortedSlaves.next()).getServerId());
        junit.framework.Assert.assertTrue((!sortedSlaves.hasNext() ? 1 : 0) != 0);
    }

    private void assertNoFailureLogs() {
        junit.framework.Assert.assertFalse((String)("Errors:" + this.log.errors.toString()), (boolean)this.log.anyMessageLogged);
    }

    private void assertFailureLogs() {
        junit.framework.Assert.assertTrue((boolean)this.log.anyMessageLogged);
    }

    private void assertCalls(FakeSlave slave, long ... txs) {
        for (long tx : txs) {
            Long slaveTx = slave.popCalledTx();
            junit.framework.Assert.assertNotNull((Object)slaveTx);
            Assert.assertEquals((Object)tx, (Object)slaveTx);
        }
        junit.framework.Assert.assertFalse((boolean)slave.moreTxs());
    }

    private MasterTxIdGenerator newGenerator(int slaveCount, int replication, SlavePriority slavePriority, boolean ... failingSlaves) throws Exception {
        this.slaves = this.instantiateSlaves(slaveCount, failingSlaves);
        this.dataSource = new FakeDataSource();
        this.log = new FakeStringLogger();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{HaSettings.tx_push_factor.name(), "" + replication}));
        MasterTxIdGenerator result = new MasterTxIdGenerator(MasterTxIdGenerator.from((Config)config, (SlavePriority)slavePriority), (StringLogger)this.log, new Slaves(){

            public Iterable<Slave> getSlaves() {
                return TestMasterCommittingAtSlave.this.slaves;
            }
        });
        try {
            result.init();
            result.start();
        }
        catch (Throwable e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        return result;
    }

    private Iterable<Slave> instantiateSlaves(int count, boolean[] failingSlaves) {
        ArrayList<Slave> slaves = new ArrayList<Slave>();
        for (int i = 0; i < count; ++i) {
            slaves.add(new FakeSlave(i < failingSlaves.length ? failingSlaves[i] : false, i));
        }
        return slaves;
    }

    private static class FakeStringLogger
    extends StringLogger {
        private volatile boolean anyMessageLogged;
        private final StringBuilder errors = new StringBuilder();

        private FakeStringLogger() {
        }

        public void logLongMessage(String msg, Visitor<StringLogger.LineLogger> source, boolean flush) {
            this.addError(msg);
        }

        private void addError(String msg) {
            this.anyMessageLogged = true;
            this.errors.append(this.errors.length() > 0 ? "," : "").append(msg);
        }

        public void logMessage(String msg, boolean flush) {
            this.addError(msg);
        }

        public void logMessage(String msg, Throwable cause, boolean flush) {
            this.addError(msg);
        }

        public void addRotationListener(Runnable listener) {
        }

        public void flush() {
        }

        public void close() {
        }

        protected void logLine(String line) {
            this.addError(line);
        }
    }

    private static class FakeSlave
    implements Slave {
        private volatile Queue<Long> calledWithTxId = new LinkedList<Long>();
        private final boolean failing;
        private final int serverId;

        FakeSlave(boolean failing, int serverId) {
            this.failing = failing;
            this.serverId = serverId;
        }

        public Response<Void> pullUpdates(String resource, long txId) {
            if (this.failing) {
                throw new ComException("Told to fail");
            }
            this.calledWithTxId.add(txId);
            return new Response(null, new StoreId(), TransactionStream.EMPTY, ResourceReleaser.NO_OP);
        }

        Long popCalledTx() {
            return this.calledWithTxId.poll();
        }

        boolean moreTxs() {
            return !this.calledWithTxId.isEmpty();
        }

        public int getServerId() {
            return this.serverId;
        }

        public String toString() {
            return "FakeSlave[" + this.serverId + "]";
        }
    }

    private static class FakeDataSource
    extends XaDataSource {
        private static final byte[] BRANCH = new byte[]{0, 1, 2};
        private static final String NAME = "fake";
        private final File dir = TargetDirectory.forTest(((Object)((Object)this)).getClass()).graphDbDir(true);

        FakeDataSource() {
            super(BRANCH, NAME);
        }

        public XaConnection getXaConnection() {
            throw new UnsupportedOperationException();
        }

        public LogExtractor getLogExtractor(long startTxId, long endTxIdHint) throws IOException {
            return LogExtractor.from((FileSystemAbstraction)FS, (File)this.dir, (long)startTxId);
        }

        public void init() throws Throwable {
        }

        public void start() throws Throwable {
        }

        public void stop() throws Throwable {
        }

        public void shutdown() throws Throwable {
        }
    }
}

