/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMemberMatcher;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;

public class ClusterMembersTest {
    private static URI clusterUri1 = URI.create("cluster://server1");
    private static URI clusterUri2 = URI.create("cluster://server2");
    private static URI clusterUri3 = URI.create("cluster://server3");
    private static URI haUri1 = URI.create("ha://server1?serverId=1");
    private static URI haUri2 = URI.create("ha://server2?serverId=2");
    private static URI haUri3 = URI.create("ha://server3?serverId=3");

    @Test
    public void shouldRegisterItselfOnListeners() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ((BindingNotifier)Mockito.verify((Object)binding)).addBindingListener((BindingListener)Mockito.any());
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)Mockito.any());
        ((Heartbeat)Mockito.verify((Object)heartbeat)).addHeartbeatListener((HeartbeatListener)Mockito.any());
        ((ClusterMemberEvents)Mockito.verify((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)Mockito.any());
    }

    @Test
    public void shouldContainMemberListAfterEnteringCluster() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri1)), ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri2)), ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri3))}));
    }

    @Test
    public void joinedMemberShowsInList() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2));
        ((ClusterListener)listener.getValue()).joinedCluster(clusterUri3);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri1)), ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri2)), ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri3))}));
    }

    @Test
    public void leftMemberDisappearsFromList() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ((ClusterListener)listener.getValue()).leftCluster(clusterUri3);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri3))})));
    }

    @Test
    public void availableMasterShowsProperInformation() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor clusterMemberListener = ArgumentCaptor.forClass(ClusterMemberListener.class);
        ((ClusterMemberEvents)Mockito.verify((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)clusterMemberListener.capture());
        ((ClusterMemberListener)clusterMemberListener.getValue()).memberIsAvailable("master", clusterUri1, haUri1);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri1).availableAs("master", haUri1))));
    }

    @Test
    public void availableSlaveShowsProperInformation() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor clusterMemberListener = ArgumentCaptor.forClass(ClusterMemberListener.class);
        ((ClusterMemberEvents)Mockito.verify((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)clusterMemberListener.capture());
        ((ClusterMemberListener)clusterMemberListener.getValue()).memberIsAvailable("slave", clusterUri1, haUri1);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri1).availableAs("slave", haUri1))));
    }

    @Test
    public void membersShowsAsUnavailableWhenNewMasterElectedBeforeTheyBecomeAvailable() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor clusterMemberListener = ArgumentCaptor.forClass(ClusterMemberListener.class);
        ((ClusterMemberEvents)Mockito.verify((Object)clusterMemberEvents)).addClusterMemberListener((ClusterMemberListener)clusterMemberListener.capture());
        ((ClusterMemberListener)clusterMemberListener.getValue()).memberIsAvailable("slave", clusterUri1, haUri1);
        ((ClusterMemberListener)clusterMemberListener.getValue()).masterIsElected(clusterUri2);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri1))));
    }

    @Test
    public void failedMemberShowsAsSuch() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor heartBeatListener = ArgumentCaptor.forClass(HeartbeatListener.class);
        ((Heartbeat)Mockito.verify((Object)heartbeat)).addHeartbeatListener((HeartbeatListener)heartBeatListener.capture());
        ((HeartbeatListener)heartBeatListener.getValue()).failed(clusterUri1);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri1).failed())));
    }

    @Test
    public void failedThenAliveMemberShowsAsAlive() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        BindingNotifier binding = (BindingNotifier)Mockito.mock(BindingNotifier.class);
        Heartbeat heartbeat = (Heartbeat)Mockito.mock(Heartbeat.class);
        ClusterMemberEvents clusterMemberEvents = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        ClusterMembers members = new ClusterMembers(cluster, binding, heartbeat, clusterMemberEvents);
        ArgumentCaptor listener = ArgumentCaptor.forClass(ClusterListener.class);
        ((Cluster)Mockito.verify((Object)cluster)).addClusterListener((ClusterListener)listener.capture());
        ((ClusterListener)listener.getValue()).enteredCluster(this.clusterConfiguration(clusterUri1, clusterUri2, clusterUri3));
        ArgumentCaptor heartBeatListener = ArgumentCaptor.forClass(HeartbeatListener.class);
        ((Heartbeat)Mockito.verify((Object)heartbeat)).addHeartbeatListener((HeartbeatListener)heartBeatListener.capture());
        ((HeartbeatListener)heartBeatListener.getValue()).failed(clusterUri1);
        ((HeartbeatListener)heartBeatListener.getValue()).alive(clusterUri1);
        Assert.assertThat((Object)members.getMembers(), (Matcher)CoreMatchers.hasItem(ClusterMemberMatcher.sameMemberAs(new ClusterMember(clusterUri1))));
    }

    private ClusterConfiguration clusterConfiguration(URI ... uris) {
        return new ClusterConfiguration("neo4j.ha", Arrays.asList(uris));
    }
}

