/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.TargetDirectory;

public class TestEnterpriseCacheType {
    private String storeDir = TargetDirectory.forTest(this.getClass()).graphDbDir(true).getAbsolutePath();
    private GraphDatabaseAPI db;

    @Test
    public void defaultEmbeddedGraphDbShouldUseGcr() throws Exception {
        this.db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir);
        Assert.assertEquals((Object)"gcr", (Object)this.getCacheTypeUsed());
    }

    @Test
    public void defaultHaGraphDbShouldUseGcr() throws Exception {
        this.db = (GraphDatabaseAPI)new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.storeDir).setConfig(HaSettings.server_id, "1").newGraphDatabase();
        Assert.assertEquals((Object)"gcr", (Object)this.getCacheTypeUsed());
    }

    private String getCacheTypeUsed() {
        return (String)((Config)this.db.getDependencyResolver().resolveDependency(Config.class)).get((Setting)GraphDatabaseSettings.cache_type);
    }

    @After
    public void after() throws Exception {
        if (this.db != null) {
            this.db.shutdown();
        }
    }
}

