/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.core.NodeImpl", method="updateSize")})
@RunWith(value=SubProcessTestRunner.class)
public class TestGcrCacheRemoveSizeDiverge {
    private static EmbeddedGraphDatabase graphdb;
    private static DebuggedThread thread;
    private static CountDownLatch latch;

    @BeforeClass
    public static void startDb() {
        try {
            graphdb = new EmbeddedGraphDatabase(TargetDirectory.forTest(TestGcrCacheRemoveSizeDiverge.class).graphDbDir(true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.cache_type.name(), "gcr"}));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void shutdownDb() {
        try {
            if (graphdb != null) {
                graphdb.shutdown();
            }
        }
        finally {
            graphdb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNodeWithSomeRelationships() {
        Transaction tx = graphdb.beginTx();
        try {
            Node node = graphdb.createNode();
            for (int i = 0; i < 10; ++i) {
                node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    @BreakpointHandler(value={"updateSize"})
    public static void onUpdateSize(BreakPoint self, DebugInterface di) {
        self.disable();
        thread = di.thread().suspend(null);
        latch.countDown();
    }

    @BreakpointHandler(value={"resumeUpdateSize"})
    public static void onResumeUpdateSize(BreakPoint self, DebugInterface di) {
        thread.resume();
    }

    @BreakpointTrigger(value="resumeUpdateSize")
    private void resumeUpdateSize() {
    }

    @BreakpointTrigger(value="enableBreakpoints")
    private void enableBreakpoints() {
    }

    @BreakpointHandler(value={"enableBreakpoints"})
    public static void onEnableBreakpoints(@BreakpointHandler(value={"updateSize"}) BreakPoint updateSize, DebugInterface di) {
        updateSize.enable();
    }

    @Test
    @EnabledBreakpoints(value={"enableBreakpoints", "resumeUpdateSize"})
    public void removeFromCacheInBetweenOtherThreadStateChangeAndUpdateSize() throws Exception {
        final Node node = this.createNodeWithSomeRelationships();
        graphdb.getNodeManager().clearCache();
        this.enableBreakpoints();
        graphdb.getNodeById(node.getId());
        final Cache nodeCache = (Cache)graphdb.getNodeManager().caches().iterator().next();
        Assert.assertTrue((String)"We didn't get a hold of the right cache object", (boolean)nodeCache.getName().toLowerCase().contains("node"));
        Thread t1 = new Thread("T1: Relationship loader"){

            @Override
            public void run() {
                IteratorUtil.count((Iterable)node.getRelationships());
            }
        };
        t1.start();
        Thread.sleep(2000L);
        Thread t2 = new Thread("T2: Cache remover"){

            @Override
            public void run() {
                nodeCache.remove(node.getId());
            }
        };
        t2.start();
        t2.join();
        this.resumeUpdateSize();
        t1.join();
        Assert.assertEquals((String)("Invalid cache size for " + nodeCache), (long)0L, (long)nodeCache.size());
    }

    static {
        latch = new CountDownLatch(1);
    }
}

