/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.ClusterManager;

public class ClusterTest {
    @Rule
    public LoggerRule logging = new LoggerRule();

    @Test
    public void testCluster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("testCluster", true), MapUtil.stringMap((String[])new String[0]));
        clusterManager.start();
        HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
        Transaction tx = master.beginTx();
        master.createNode();
        tx.success();
        tx.finish();
        clusterManager.stop();
    }

    @Test
    public void testArbiterStartsFirstAndThenTwoInstancesJoin() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.clusterWithAdditionalArbiters(2, 1), TargetDirectory.forTest(this.getClass()).directory("testCluster", true), MapUtil.stringMap((String[])new String[0]));
        clusterManager.start();
        HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
        Transaction tx = master.beginTx();
        master.createNode();
        tx.success();
        tx.finish();
        clusterManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RuntimeException.class)
    public void testInstancesWithConflictingPorts() throws Throwable {
        ClusterManager clusterManager = null;
        try {
            clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/threeinstancesconflictingports.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("testClusterConflictingPorts", true), MapUtil.stringMap((String[])new String[0]));
            clusterManager.start();
        }
        finally {
            clusterManager.stop();
        }
    }

    @Test
    public void given4instanceclusterWhenMasterGoesDownThenElectNewMaster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager(ClusterManager.fromXml(this.getClass().getResource("/fourinstances.xml").toURI()), TargetDirectory.forTest(this.getClass()).directory("4instances", true), MapUtil.stringMap((String[])new String[0]));
        clusterManager.start();
        this.logging.getLogger().info("STOPPING MASTER");
        clusterManager.getDefaultCluster().getMaster().stop();
        this.logging.getLogger().info("STOPPED MASTER");
        Thread.sleep(30000L);
        HighlyAvailableGraphDatabase master = clusterManager.getCluster("neo4j.ha").getMaster();
        this.logging.getLogger().info("CREATE NODE");
        Transaction tx = master.beginTx();
        master.createNode();
        this.logging.getLogger().info("CREATED NODE");
        tx.success();
        tx.finish();
        this.logging.getLogger().info("STOPPING CLUSTER");
        clusterManager.stop();
    }
}

