/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.AbstractClusterTest;
import org.neo4j.test.ha.ClusterManager;

public class TestStoreCopy
extends AbstractClusterTest {
    private static final String KEY = "foo";
    private static final String KEY2 = "foo2";
    private static final String VALUE = "bar";
    private static final String VALUE2 = "bar2";
    private static final FileFilter DISREGARD_ACTIVE_LOG_FILES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !"active_tx_log tm_tx_log.1 tm_tx_log.2".contains(file.getName());
        }
    };
    private long nodeId;
    private HighlyAvailableGraphDatabase slave;
    private File slaveDir;
    private File slaveTempCopyDir;

    @Test
    public void sandboxIsOverwritten() throws Throwable {
        ClusterManager.RepairKit slaveDown = this.cluster.shutdown(this.slave);
        long secondNodeId = this.createIndexedNode((GraphDatabaseService)this.cluster.getMaster(), KEY2, VALUE2);
        FileUtils.moveToDirectory((File)new File(this.slaveDir, "neostore"), (File)this.slaveTempCopyDir, (boolean)false);
        FileUtils.moveToDirectory((File)new File(this.slaveDir, "neostore.propertystore.db"), (File)this.slaveTempCopyDir, (boolean)false);
        Assert.assertEquals((String)("Found these files:" + this.filesAsString(this.slaveTempCopyDir)), (long)3L, (long)this.slaveTempCopyDir.listFiles(DISREGARD_ACTIVE_LOG_FILES).length);
        this.slave = slaveDown.repair();
        this.assertNodeAndIndexingExists(this.slave, this.nodeId, KEY, VALUE);
        this.assertNodeAndIndexingExists(this.slave, secondNodeId, KEY2, VALUE2);
    }

    @Before
    public void simpleSanityCheck() throws Exception {
        this.slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.slaveDir = this.cluster.getStoreDir(this.slave);
        this.slaveTempCopyDir = new File(this.slaveDir, "temp-copy");
        Assert.assertEquals((Object)VALUE, (Object)this.slave.getNodeById(this.nodeId).getProperty(KEY));
    }

    @After
    public void assertSandboxLeftoverContents() throws Exception {
        Assert.assertTrue((boolean)this.slaveTempCopyDir.exists());
        Assert.assertTrue((boolean)this.slaveTempCopyDir.isDirectory());
        Assert.assertEquals((long)1L, (long)this.slaveTempCopyDir.listFiles(DISREGARD_ACTIVE_LOG_FILES).length);
        Assert.assertEquals((Object)"messages.log", (Object)this.slaveTempCopyDir.listFiles(DISREGARD_ACTIVE_LOG_FILES)[0].getName());
    }

    public TestStoreCopy() {
        super(ClusterManager.clusterWithAdditionalClients(2, 1));
    }

    @Override
    protected void insertClusterMemberInitialData(GraphDatabaseService db, String name, int serverId) {
        if (serverId == 1) {
            this.nodeId = this.createIndexedNode(db, KEY, VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createIndexedNode(GraphDatabaseService db, String key, String value) {
        Transaction tx = db.beginTx();
        try {
            Node n = db.createNode();
            n.setProperty(key, (Object)value);
            db.index().forNodes(key).add((PropertyContainer)n, key, (Object)value);
            long nodeId = n.getId();
            tx.success();
            long l = nodeId;
            return l;
        }
        finally {
            tx.finish();
        }
    }

    private String filesAsString(File directory) {
        StringBuilder builder = new StringBuilder();
        for (File file : directory.listFiles(DISREGARD_ACTIVE_LOG_FILES)) {
            builder.append("\n").append(file.isDirectory() ? "/" : "").append(file.getName());
        }
        return builder.toString();
    }

    private void assertNodeAndIndexingExists(HighlyAvailableGraphDatabase db, long nodeId, String key, Object value) {
        Node node = db.getNodeById(nodeId);
        Assert.assertEquals((String)("Property '" + key + "'='" + value + "' mismatch on " + node + " for " + db), (Object)value, (Object)node.getProperty(key));
        Assert.assertTrue((String)("Index '" + key + "' not found for " + db), (boolean)db.index().existsForNodes(key));
        Assert.assertEquals((String)("Index '" + key + "'='" + value + "' mismatch on " + node + " for " + db), (Object)node, (Object)db.index().forNodes(key).get(key, value).getSingle());
    }
}

