/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;

public class HaKernelPanicHandler
implements KernelEventHandler {
    private final XaDataSourceManager dataSourceManager;
    private final TxManager txManager;
    private final AtomicInteger epoch = new AtomicInteger();

    public HaKernelPanicHandler(XaDataSourceManager dataSourceManager, TxManager txManager) {
        this.dataSourceManager = dataSourceManager;
        this.txManager = txManager;
    }

    public void beforeShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kernelPanic(ErrorState error) {
        if (error == ErrorState.TX_MANAGER_NOT_OK) {
            try {
                int myEpoch = this.epoch.get();
                XaDataSourceManager xaDataSourceManager = this.dataSourceManager;
                synchronized (xaDataSourceManager) {
                    if (myEpoch != this.epoch.get()) {
                        return;
                    }
                    this.txManager.stop();
                    this.dataSourceManager.stop();
                    this.dataSourceManager.start();
                    this.txManager.start();
                    this.txManager.doRecovery();
                    this.epoch.incrementAndGet();
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("error while handling kernel panic for TX_MANAGER_NOT_OK", t);
            }
        }
    }

    public Object getResource() {
        return null;
    }

    public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
        return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
    }
}

