/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.neo4j.cluster.protocol.election.ElectionCredentials;

public final class DefaultElectionCredentials
implements ElectionCredentials,
Externalizable {
    private int serverId;
    private long latestTxId;
    private boolean currentWinner;

    public DefaultElectionCredentials() {
    }

    public DefaultElectionCredentials(int serverId, long latestTxId, boolean currentWinner) {
        this.serverId = serverId;
        this.latestTxId = latestTxId;
        this.currentWinner = currentWinner;
    }

    public int compareTo(Object o) {
        DefaultElectionCredentials other = (DefaultElectionCredentials)o;
        if (this.latestTxId == other.latestTxId) {
            if (this.currentWinner == other.currentWinner) {
                return Integer.signum(other.serverId - this.serverId);
            }
            return other.currentWinner ? -1 : 1;
        }
        return Long.signum(this.latestTxId - other.latestTxId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultElectionCredentials)) {
            return false;
        }
        DefaultElectionCredentials other = (DefaultElectionCredentials)obj;
        return other.serverId == this.serverId && other.latestTxId == this.latestTxId && other.currentWinner == this.currentWinner;
    }

    public int hashCode() {
        return (int)((long)(17 * this.serverId) + this.latestTxId);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.serverId);
        out.writeLong(this.latestTxId);
        out.writeBoolean(this.currentWinner);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serverId = in.readInt();
        this.latestTxId = in.readLong();
        this.currentWinner = in.readBoolean();
    }

    public String toString() {
        return "DefaultElectionCredentials[serverId=" + this.serverId + ", latestTxId=" + this.latestTxId + ", currentWinner=" + this.currentWinner + "]";
    }
}

